/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.jboss.shrinkwrap.resolver.api.maven.MavenArtifactInfo;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;

public class MavenArtifactInfoImpl
implements MavenArtifactInfo {
    private static final Logger log = Logger.getLogger(MavenArtifactInfoImpl.class.getName());
    protected final MavenCoordinate mavenCoordinate;
    protected final String resolvedVersion;
    protected final boolean snapshotVersion;
    protected final String extension;
    protected final ScopeType scopeType;
    protected final boolean optional;
    protected final MavenArtifactInfo[] dependencies;

    protected MavenArtifactInfoImpl(MavenCoordinate mavenCoordinate, String resolvedVersion, boolean snapshotVersion, String extension, ScopeType scopeType, MavenArtifactInfo[] dependencies, boolean optional) {
        this.mavenCoordinate = mavenCoordinate;
        this.resolvedVersion = resolvedVersion;
        this.snapshotVersion = snapshotVersion;
        this.extension = extension;
        this.scopeType = scopeType;
        this.dependencies = (MavenArtifactInfo[])dependencies.clone();
        this.optional = optional;
    }

    protected MavenArtifactInfoImpl(Artifact artifact, ScopeType scopeType, List<DependencyNode> children2, boolean optional) {
        PackagingType packaging = PackagingType.of(artifact.getProperty("type", artifact.getExtension()));
        String classifier2 = artifact.getClassifier().length() == 0 ? packaging.getClassifier() : artifact.getClassifier();
        this.mavenCoordinate = MavenCoordinates.createCoordinate(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), packaging, classifier2);
        this.resolvedVersion = artifact.getVersion();
        this.snapshotVersion = artifact.isSnapshot();
        this.extension = artifact.getExtension();
        this.dependencies = this.parseDependencies(children2);
        this.scopeType = scopeType;
        this.optional = optional;
    }

    static MavenArtifactInfo fromDependencyNode(DependencyNode dependencyNode) {
        Artifact artifact = dependencyNode.getDependency().getArtifact();
        List<DependencyNode> children2 = dependencyNode.getChildren();
        ScopeType scopeType = ScopeType.RUNTIME;
        try {
            scopeType = ScopeType.fromScopeType(dependencyNode.getDependency().getScope());
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, "Invalid scope {0} of retrieved dependency {1} will be replaced by <scope>runtime</scope>", new Object[]{dependencyNode.getDependency().getScope(), dependencyNode.getDependency().getArtifact()});
        }
        boolean optional = dependencyNode.getDependency().isOptional();
        return new MavenArtifactInfoImpl(artifact, scopeType, children2, optional);
    }

    protected MavenArtifactInfo[] parseDependencies(List<DependencyNode> children2) {
        MavenArtifactInfo[] dependecies = new MavenArtifactInfo[children2.size()];
        int i = 0;
        for (DependencyNode child : children2) {
            dependecies[i++] = MavenArtifactInfoImpl.fromDependencyNode(child);
        }
        return dependecies;
    }

    @Override
    public MavenCoordinate getCoordinate() {
        return this.mavenCoordinate;
    }

    @Override
    public String getResolvedVersion() {
        return this.resolvedVersion;
    }

    @Override
    public boolean isSnapshotVersion() {
        return this.snapshotVersion;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public MavenArtifactInfo[] getDependencies() {
        return this.dependencies;
    }

    @Override
    public ScopeType getScope() {
        return this.scopeType;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    public String toString() {
        return "MavenArtifactInfoImpl [mavenCoordinate=" + this.mavenCoordinate + ", resolvedVersion=" + this.resolvedVersion + ", snapshotVersion=" + this.snapshotVersion + ", extension=" + this.extension + ", scope=" + (Object)((Object)this.scopeType) + ", dependencies=" + Arrays.toString(this.dependencies) + "]";
    }
}

