/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.repository;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenChecksumPolicy;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenUpdatePolicy;

class MavenRemoteRepositoryImpl
implements MavenRemoteRepository {
    String id;
    String layout;
    URL url;
    MavenUpdatePolicy upPolicy = null;
    MavenChecksumPolicy ckPolicy = null;

    MavenRemoteRepositoryImpl(String id2, String url2, String layout) throws MalformedURLException {
        this(id2, new URL(url2), layout);
    }

    MavenRemoteRepositoryImpl(String id2, URL url2, String layout) {
        if (id2 == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (url2 == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (layout == null) {
            throw new IllegalArgumentException("layout cannot be null");
        }
        if (!layout.equals("default")) {
            throw new IllegalArgumentException("layout must be default. Parameter reserved for later use");
        }
        this.id = id2;
        this.layout = layout;
        this.url = url2;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.layout;
    }

    @Override
    public String getUrl() {
        return this.url.toString();
    }

    @Override
    public MavenUpdatePolicy getUpdatePolicy() {
        return this.upPolicy;
    }

    @Override
    public MavenChecksumPolicy getChecksumPolicy() {
        return this.ckPolicy;
    }

    @Override
    public MavenRemoteRepository setUpdatePolicy(MavenUpdatePolicy policy) {
        this.upPolicy = policy;
        return this;
    }

    @Override
    public MavenRemoteRepository setChecksumPolicy(MavenChecksumPolicy policy) {
        this.ckPolicy = policy;
        return this;
    }
}

