/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.coordinate;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinateImpl;

public final class MavenCoordinates {
    private MavenCoordinates() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    public static MavenCoordinate createCoordinate(String canonicalForm) throws IllegalArgumentException, CoordinateParseException {
        if (canonicalForm == null || canonicalForm.length() == 0) {
            throw new IllegalArgumentException("canonical form is required");
        }
        MavenCoordinateParser parser = MavenCoordinateParser.parse(canonicalForm);
        return MavenCoordinates.createCoordinate(parser.getGroupId(), parser.getArtifactId(), parser.getVersion(), parser.getPackaging(), parser.getClassifier());
    }

    public static MavenCoordinate createCoordinate(String groupId, String artifactId, String version2, PackagingType packaging, String classifier2) throws IllegalArgumentException {
        if (groupId == null || groupId.length() == 0) {
            throw new IllegalArgumentException("groupId is required");
        }
        if (artifactId == null || artifactId.length() == 0) {
            throw new IllegalArgumentException("artifactId is required");
        }
        MavenCoordinateImpl coordinate = new MavenCoordinateImpl(groupId, artifactId, version2, packaging, classifier2);
        return coordinate;
    }

    static class MavenCoordinateParser {
        private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?(:([^: ]+))?");
        private static final String EMPTY_STRING = "";
        private static final int IS_POS_1 = 1;
        private static final int ID_POS_2 = 2;
        private static final int ID_POS_3 = 4;
        private static final int ID_POS_4 = 6;
        private static final int ID_POS_5 = 8;
        private String groupId;
        private String artifactId;
        private PackagingType type = PackagingType.JAR;
        private String classifier = "";
        private String version;

        private MavenCoordinateParser() {
        }

        static MavenCoordinateParser parse(String coordinates) throws CoordinateParseException {
            Matcher m4 = DEPENDENCY_PATTERN.matcher(coordinates);
            if (!m4.matches()) {
                throw new CoordinateParseException("Bad artifact coordinates, expected format is <groupId>:<artifactId>[:<packagingType>[:<classifier>]]:(<version>|'?'), got: " + coordinates);
            }
            MavenCoordinateParser parser = new MavenCoordinateParser();
            parser.groupId = m4.group(1);
            parser.artifactId = m4.group(2);
            String position3 = m4.group(4);
            String position4 = m4.group(6);
            String position5 = m4.group(8);
            int noOfColons = MavenCoordinateParser.numberOfOccurrences(coordinates, ':');
            switch (noOfColons) {
                case 2: {
                    parser.version = position3;
                    break;
                }
                case 3: {
                    parser.type = position3 == null || position3.length() == 0 ? PackagingType.JAR : MavenCoordinateParser.toPackagingType(position3);
                    parser.version = position4;
                    break;
                }
                default: {
                    parser.type = position3 == null || position3.length() == 0 ? PackagingType.JAR : MavenCoordinateParser.toPackagingType(position3);
                    parser.classifier = position4;
                    parser.version = position5;
                }
            }
            return parser;
        }

        public PackagingType getPackaging() {
            return this.type;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getVersion() {
            return this.version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        private static int numberOfOccurrences(CharSequence haystack, char needle) {
            int counter = 0;
            for (int i = 0; i < haystack.length(); ++i) {
                if (haystack.charAt(i) != needle) continue;
                ++counter;
            }
            return counter;
        }

        private static PackagingType toPackagingType(String type2) {
            assert (type2 != null) : "Should not be fed a null type via internals (regardless of user input)";
            PackagingType parsedPackagingType = null;
            try {
                parsedPackagingType = PackagingType.of(type2);
            }
            catch (IllegalArgumentException iae) {
                throw new CoordinateParseException(iae.getMessage());
            }
            return parsedPackagingType;
        }
    }
}

