/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;

class Invokable {
    private final Class<?> classType;

    Invokable(ClassLoader cl, String className) {
        this.classType = Invokable.loadClass(cl, className);
    }

    Invokable(ClassLoader cl, Class<?> classType) {
        this.classType = Invokable.reloadClass(cl, classType);
    }

    static Class<?> loadClass(ClassLoader cl, String classTypeName) throws InvocationException {
        try {
            return cl.loadClass(classTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new InvocationException(e, "Unable to load class {0} with class loader {1}", classTypeName, cl);
        }
    }

    static Class<?> reloadClass(ClassLoader cl, Class<?> classType) throws InvocationException {
        try {
            return cl.loadClass(classType.getName());
        }
        catch (ClassNotFoundException e) {
            throw new InvocationException(e, "Unable to reload class {0} with class loader {1}, previously loaded with {2}", classType.getName(), cl, classType.getClassLoader());
        }
    }

    Object invokeMethod(String name2, Class<?>[] parameterTypes, Object instance, Object[] parameters2) throws InvocationException {
        try {
            return this.findMethod(name2, parameterTypes).invoke(instance, parameters2);
        }
        catch (IllegalAccessException e) {
            throw new InvocationException(e, "Unable to invoke {0}({1}) on object {2} with parameters {3}", name2, parameterTypes, instance == null ? "" : instance.getClass().getName(), parameters2);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationException(e, "Unable to invoke {0}({1}) on object {2} with parameters {3}", name2, parameterTypes, instance == null ? "" : instance.getClass().getName(), parameters2);
        }
        catch (InvocationTargetException e) {
            throw new InvocationException(e, "Unable to invoke {0}({1}) on object {2} with parameters {3}", name2, parameterTypes, instance == null ? "" : instance.getClass().getName(), parameters2);
        }
        catch (SecurityException e) {
            throw new InvocationException(e, "Unable to invoke {0}({1}) on object {2} with parameters {3}", name2, parameterTypes, instance == null ? "" : instance.getClass().getName(), parameters2);
        }
        catch (InvocationException e) {
            throw new InvocationException(e, "Unable to invoke {0}({1}) on object {2} with parameters {3}", name2, parameterTypes, instance == null ? "" : instance.getClass().getName(), parameters2);
        }
    }

    Object invokeConstructor(Class<?>[] parameterTypes, Object[] parameters2) throws InvocationException {
        try {
            Constructor<?> con = this.classType.getConstructor(parameterTypes);
            return con.newInstance(parameters2);
        }
        catch (NoSuchMethodException e) {
            throw new InvocationException(e, "Unable to invoke constructor {0}({1}) with parameters {3}", this.classType.getSimpleName(), parameterTypes, parameters2);
        }
        catch (SecurityException e) {
            throw new InvocationException(e, "Unable to invoke constructor {0}({1}) with parameters {3}", this.classType.getSimpleName(), parameterTypes, parameters2);
        }
        catch (InstantiationException e) {
            throw new InvocationException(e, "Unable to invoke constructor {0}({1}) with parameters {3}", this.classType.getSimpleName(), parameterTypes, parameters2);
        }
        catch (IllegalAccessException e) {
            throw new InvocationException(e, "Unable to invoke constructor {0}({1}) with parameters {3}", this.classType.getSimpleName(), parameterTypes, parameters2);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationException(e, "Unable to invoke constructor {0}({1}) with parameters {3}", this.classType.getSimpleName(), parameterTypes, parameters2);
        }
        catch (InvocationTargetException e) {
            throw new InvocationException(e, "Unable to invoke constructor {0}({1}) with parameters {3}", this.classType.getSimpleName(), parameterTypes, parameters2);
        }
    }

    private Method findMethod(String name2, Class<?>[] parameterTypes) throws SecurityException, InvocationException {
        Method m4 = null;
        try {
            m4 = this.classType.getDeclaredMethod(name2, parameterTypes);
            m4.setAccessible(true);
            return m4;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            for (Class<?> iterator2 = this.classType.getSuperclass(); iterator2 != null; iterator2 = iterator2.getSuperclass()) {
                try {
                    m4 = iterator2.getDeclaredMethod(name2, parameterTypes);
                    m4.setAccessible(true);
                    return m4;
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
            throw new InvocationException("Unable to find method {0}({1}) in class {2} nor its superclasses or implemented interfaces", name2, parameterTypes, this.classType.getName());
        }
    }

    static class InvocationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        InvocationException(Throwable e) {
            super(e);
        }

        InvocationException(Throwable e, String pattern, Object ... args2) {
            super(MessageFormat.format(pattern, args2), e);
        }

        InvocationException(String pattern, Object ... args2) {
            super(MessageFormat.format(pattern, args2));
        }
    }
}

