/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.io.tar;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.activation.FileTypeMap;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.jboss.shrinkwrap.impl.base.io.tar.TarEntry;
import org.jboss.shrinkwrap.impl.base.io.tar.TarInputStream;
import org.jboss.shrinkwrap.impl.base.io.tar.TarOutputStreamImpl;
import org.jboss.shrinkwrap.impl.base.io.tar.TarProgressDisplay;
import org.jboss.shrinkwrap.impl.base.io.tar.TarTransFileTyper;

public class TarArchive {
    protected boolean verbose;
    protected boolean debug;
    protected boolean keepOldFiles;
    protected boolean asciiTranslate;
    protected int userId;
    protected String userName;
    protected int groupId;
    protected String groupName;
    protected String rootPath;
    protected String tempPath;
    protected String pathPrefix;
    protected int recordSize;
    protected byte[] recordBuf;
    protected TarInputStream tarIn;
    protected TarOutputStreamImpl tarOut;
    protected TarTransFileTyper transTyper;
    protected TarProgressDisplay progressDisplay;

    public TarArchive(InputStream inStream) {
        this(inStream, 10240);
    }

    public TarArchive(InputStream inStream, int blockSize) {
        this(inStream, blockSize, 512);
    }

    public TarArchive(InputStream inStream, int blockSize, int recordSize) {
        this.tarIn = new TarInputStream(inStream, blockSize, recordSize);
        this.initialize(recordSize);
    }

    public TarArchive(OutputStream outStream) {
        this(outStream, 10240);
    }

    public TarArchive(OutputStream outStream, int blockSize) {
        this(outStream, blockSize, 512);
    }

    public TarArchive(OutputStream outStream, int blockSize, int recordSize) {
        this.tarOut = new TarOutputStreamImpl(outStream, blockSize, recordSize);
        this.initialize(recordSize);
    }

    private void initialize(int recordSize) {
        this.rootPath = null;
        this.pathPrefix = null;
        this.tempPath = System.getProperty("user.dir");
        this.userId = 0;
        this.userName = "";
        this.groupId = 0;
        this.groupName = "";
        this.debug = false;
        this.verbose = false;
        this.keepOldFiles = false;
        this.progressDisplay = null;
        this.recordBuf = new byte[this.getRecordSize()];
    }

    public void setDebug(boolean debugF) {
        this.debug = debugF;
        if (this.tarIn != null) {
            this.tarIn.setDebug(debugF);
        } else if (this.tarOut != null) {
            this.tarOut.setDebug(debugF);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setTarProgressDisplay(TarProgressDisplay display) {
        this.progressDisplay = display;
    }

    public void setKeepOldFiles(boolean keepOldFiles) {
        this.keepOldFiles = keepOldFiles;
    }

    public void setAsciiTranslation(boolean asciiTranslate) {
        this.asciiTranslate = asciiTranslate;
    }

    public void setTransFileTyper(TarTransFileTyper transTyper) {
        this.transTyper = transTyper;
    }

    public void setUserInfo(int userId, String userName, int groupId, String groupName) {
        this.userId = userId;
        this.userName = userName;
        this.groupId = groupId;
        this.groupName = groupName;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getTempDirectory() {
        return this.tempPath;
    }

    public void setTempDirectory(String path) {
        this.tempPath = path;
    }

    public int getRecordSize() {
        if (this.tarIn != null) {
            return this.tarIn.getRecordSize();
        }
        if (this.tarOut != null) {
            return this.tarOut.getRecordSize();
        }
        return 512;
    }

    private String getTempFilePath(File eFile) {
        File f;
        String pathStr = this.tempPath + File.separator + eFile.getName() + ".tmp";
        for (int i = 1; i < 5 && (f = new File(pathStr)).exists(); ++i) {
            pathStr = this.tempPath + File.separator + eFile.getName() + "-" + i + ".tmp";
        }
        return pathStr;
    }

    public void closeArchive() throws IOException {
        if (this.tarIn != null) {
            this.tarIn.close();
        } else if (this.tarOut != null) {
            this.tarOut.close();
        }
    }

    public void listContents() throws IOException {
        while (true) {
            TarEntry entry2;
            if ((entry2 = this.tarIn.getNextEntry()) == null) {
                if (!this.debug) break;
                System.err.println("READ EOF RECORD");
                break;
            }
            if (this.progressDisplay == null) continue;
            this.progressDisplay.showTarProgressMessage(entry2.getName());
        }
    }

    public void extractContents(File destDir) throws IOException {
        while (true) {
            TarEntry entry2;
            if ((entry2 = this.tarIn.getNextEntry()) == null) {
                if (!this.debug) break;
                System.err.println("READ EOF RECORD");
                break;
            }
            this.extractEntry(destDir, entry2);
        }
    }

    private void extractEntry(File destDir, TarEntry entry2) throws IOException {
        if (this.verbose && this.progressDisplay != null) {
            this.progressDisplay.showTarProgressMessage(entry2.getName());
        }
        String name2 = entry2.getName();
        name2 = name2.replace('/', File.separatorChar);
        File destFile = new File(destDir, name2);
        if (entry2.isDirectory()) {
            if (!destFile.exists() && !destFile.mkdirs()) {
                throw new IOException("error making directory path '" + destFile.getPath() + "'");
            }
        } else {
            File subDir = new File(destFile.getParent());
            if (!subDir.exists() && !subDir.mkdirs()) {
                throw new IOException("error making directory path '" + subDir.getPath() + "'");
            }
            if (this.keepOldFiles && destFile.exists()) {
                if (this.verbose && this.progressDisplay != null) {
                    this.progressDisplay.showTarProgressMessage("not overwriting " + entry2.getName());
                }
            } else {
                int numRead;
                boolean asciiTrans = false;
                FileOutputStream out = new FileOutputStream(destFile);
                if (this.asciiTranslate) {
                    MimeType mime = null;
                    String contentType = null;
                    try {
                        contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(destFile);
                        mime = new MimeType(contentType);
                        if (mime.getPrimaryType().equalsIgnoreCase("text")) {
                            asciiTrans = true;
                        } else if (this.transTyper != null && this.transTyper.isAsciiFile(entry2.getName())) {
                            asciiTrans = true;
                        }
                    }
                    catch (MimeTypeParseException mimeTypeParseException) {
                        // empty catch block
                    }
                    if (this.debug) {
                        System.err.println("EXTRACT TRANS? '" + asciiTrans + "'  ContentType='" + contentType + "'  PrimaryType='" + mime.getPrimaryType() + "'");
                    }
                }
                PrintWriter outw = null;
                if (asciiTrans) {
                    outw = new PrintWriter(out);
                }
                byte[] rdbuf = new byte[32768];
                while ((numRead = this.tarIn.read(rdbuf)) != -1) {
                    if (asciiTrans) {
                        int off = 0;
                        for (int b = 0; b < numRead; ++b) {
                            if (rdbuf[b] != 10) continue;
                            String s2 = new String(rdbuf, off, b - off);
                            outw.println(s2);
                            off = b + 1;
                        }
                        continue;
                    }
                    out.write(rdbuf, 0, numRead);
                }
                if (asciiTrans) {
                    outw.close();
                } else {
                    out.close();
                }
            }
        }
    }

    public void writeEntry(TarEntry oldEntry, boolean recurse) throws IOException {
        boolean asciiTrans = false;
        boolean unixArchiveFormat = oldEntry.isUnixTarFormat();
        File tFile = null;
        File eFile = oldEntry.getFile();
        TarEntry entry2 = (TarEntry)oldEntry.clone();
        if (this.verbose && this.progressDisplay != null) {
            this.progressDisplay.showTarProgressMessage(entry2.getName());
        }
        if (this.asciiTranslate && !entry2.isDirectory()) {
            MimeType mime = null;
            String contentType = null;
            try {
                contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(eFile);
                mime = new MimeType(contentType);
                if (mime.getPrimaryType().equalsIgnoreCase("text")) {
                    asciiTrans = true;
                } else if (this.transTyper != null && this.transTyper.isAsciiFile(eFile)) {
                    asciiTrans = true;
                }
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                // empty catch block
            }
            if (this.debug) {
                System.err.println("CREATE TRANS? '" + asciiTrans + "'  ContentType='" + contentType + "'  PrimaryType='" + mime.getPrimaryType() + "'");
            }
            if (asciiTrans) {
                String line;
                String tempFileName = this.getTempFilePath(eFile);
                tFile = new File(tempFileName);
                BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(eFile)));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tFile));
                while ((line = in.readLine()) != null) {
                    out.write(line.getBytes());
                    out.write(10);
                }
                in.close();
                out.flush();
                out.close();
                entry2.setSize(tFile.length());
                eFile = tFile;
            }
        }
        String newName = null;
        if (this.rootPath != null && entry2.getName().startsWith(this.rootPath)) {
            newName = entry2.getName().substring(this.rootPath.length() + 1);
        }
        if (this.pathPrefix != null) {
            String string = newName = newName == null ? this.pathPrefix + "/" + entry2.getName() : this.pathPrefix + "/" + newName;
        }
        if (newName != null) {
            entry2.setName(newName);
        }
        this.tarOut.putNextEntry(entry2);
        if (entry2.isDirectory()) {
            if (recurse) {
                TarEntry[] list2 = entry2.getDirectoryEntries();
                for (int i = 0; i < list2.length; ++i) {
                    TarEntry dirEntry = list2[i];
                    if (unixArchiveFormat) {
                        dirEntry.setUnixTarFormat();
                    }
                    this.writeEntry(dirEntry, recurse);
                }
            }
        } else {
            int numRead;
            FileInputStream in = new FileInputStream(eFile);
            byte[] eBuf = new byte[32768];
            while ((numRead = in.read(eBuf, 0, eBuf.length)) != -1) {
                this.tarOut.write(eBuf, 0, numRead);
            }
            in.close();
            if (tFile != null) {
                tFile.delete();
            }
            this.tarOut.closeEntry();
        }
    }
}

