/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.formatter;

import java.util.Map;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.formatter.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum SimpleFormatter implements Formatter
{
    INSTANCE;

    private static final String ASSETS = "assets";

    @Override
    public String format(Archive<?> archive) throws IllegalArgumentException {
        if (archive == null) {
            throw new IllegalArgumentException("archive must be specified");
        }
        return archive.getName() + ':' + ' ' + this.getNumAssets(archive) + ' ' + ASSETS;
    }

    private int getNumAssets(Archive<?> archive) {
        int assets = 0;
        Map<ArchivePath, Node> content = archive.getContent();
        for (Map.Entry<ArchivePath, Node> entry2 : content.entrySet()) {
            if (entry2.getValue().getAsset() == null) continue;
            ++assets;
        }
        return assets;
    }
}

