/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.space.ClassFinder;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassVisitor;
import org.eclipse.sisu.space.DefaultClassFinder;
import org.eclipse.sisu.space.SpaceVisitor;
import org.eclipse.sisu.space.asm.AnnotationVisitor;
import org.eclipse.sisu.space.asm.ClassReader;
import org.eclipse.sisu.space.asm.Type;

public final class SpaceScanner {
    private static final int ASM_FLAGS = 7;
    static final ClassFinder DEFAULT_FINDER = new DefaultClassFinder();
    private final ClassSpace space;
    private final ClassFinder finder;

    public SpaceScanner(ClassSpace space, ClassFinder finder) {
        this.space = space;
        this.finder = finder;
    }

    public SpaceScanner(ClassSpace space) {
        this(space, DEFAULT_FINDER);
    }

    public void accept(SpaceVisitor visitor2) {
        visitor2.enterSpace(this.space);
        Enumeration<URL> result2 = this.finder.findClasses(this.space);
        while (result2.hasMoreElements()) {
            URL url2 = result2.nextElement();
            ClassVisitor cv = visitor2.visitClass(url2);
            if (cv == null) continue;
            SpaceScanner.accept(cv, url2);
        }
        visitor2.leaveSpace();
    }

    public static void accept(ClassVisitor visitor2, URL url2) {
        if (url2 == null) {
            return;
        }
        try {
            InputStream in = url2.openStream();
            try {
                new ClassReader(in).accept(SpaceScanner.adapt(visitor2), 7);
            }
            finally {
                in.close();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (Exception e) {
            Logs.trace("Problem scanning: {}", url2, e);
        }
    }

    public static String jvmDescriptor(Class<? extends Annotation> clazz) {
        return String.valueOf('L') + clazz.getName().replace('.', '/') + ';';
    }

    private static org.eclipse.sisu.space.asm.ClassVisitor adapt(final ClassVisitor _cv) {
        return _cv == null ? null : new org.eclipse.sisu.space.asm.ClassVisitor(327680){

            @Override
            public void visit(int version2, int access, String name2, String signature2, String superName, String[] interfaces) {
                _cv.enterClass(access, name2, superName, interfaces);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                final org.eclipse.sisu.space.AnnotationVisitor _av = _cv.visitAnnotation(desc);
                return _av == null ? null : new AnnotationVisitor(327680){
                    {
                        super($anonymous0);
                        annotationVisitor.enterAnnotation();
                    }

                    @Override
                    public void visit(String name2, Object value) {
                        _av.visitElement(name2, value instanceof Type ? ((Type)value).getClassName() : value);
                    }

                    @Override
                    public void visitEnd() {
                        _av.leaveAnnotation();
                    }
                };
            }

            @Override
            public void visitEnd() {
                _cv.leaveClass();
            }
        };
    }
}

