/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.SpaceModule;
import org.eclipse.sisu.space.URLClassSpace;
import org.eclipse.sisu.wire.ParameterKeys;
import org.eclipse.sisu.wire.WireModule;
import org.junit.After;
import org.junit.Before;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class InjectedTest
implements Module {
    private String basedir;
    @Inject
    private MutableBeanLocator locator;

    @Before
    @BeforeMethod
    public void setUp() throws Exception {
        Guice.createInjector((Module[])new Module[]{new WireModule(new SetUpModule(), this.spaceModule())});
    }

    @After
    @AfterMethod
    public void tearDown() throws Exception {
        this.locator.clear();
    }

    public SpaceModule spaceModule() {
        return new SpaceModule(this.space(), this.scanning());
    }

    public ClassSpace space() {
        return new URLClassSpace(this.getClass().getClassLoader());
    }

    public BeanScanning scanning() {
        return BeanScanning.CACHE;
    }

    public void configure(Binder binder) {
    }

    public void configure(Properties properties2) {
    }

    public final <T> T lookup(Class<T> type2) {
        return this.lookup(Key.get(type2));
    }

    public final <T> T lookup(Class<T> type2, String name2) {
        return this.lookup(type2, (Annotation)Names.named((String)name2));
    }

    public final <T> T lookup(Class<T> type2, Class<? extends Annotation> qualifier) {
        return this.lookup(Key.get(type2, qualifier));
    }

    public final <T> T lookup(Class<T> type2, Annotation qualifier) {
        return this.lookup(Key.get(type2, (Annotation)qualifier));
    }

    public final String getBasedir() {
        if (this.basedir == null) {
            this.basedir = System.getProperty("basedir", new File("").getAbsolutePath());
        }
        return this.basedir;
    }

    private <T> T lookup(Key<T> key) {
        Iterator i = this.locator.locate(key).iterator();
        return i.hasNext() ? (T)((Map.Entry)i.next()).getValue() : null;
    }

    final class SetUpModule
    implements Module {
        SetUpModule() {
        }

        public void configure(Binder binder) {
            binder.install((Module)InjectedTest.this);
            Properties properties2 = new Properties();
            properties2.put("basedir", InjectedTest.this.getBasedir());
            InjectedTest.this.configure(properties2);
            binder.bind(ParameterKeys.PROPERTIES).toInstance((Object)properties2);
            binder.requestInjection((Object)InjectedTest.this);
        }
    }
}

