/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationDigest;

final class SecretAuthentication
implements Authentication {
    private static final Object[] KEYS = new Object[16];
    private final String key;
    private final char[] value;
    private final int secretHash;

    SecretAuthentication(String key, String value) {
        this(value != null ? value.toCharArray() : null, key);
    }

    SecretAuthentication(String key, char[] value) {
        this(SecretAuthentication.copy(value), key);
    }

    private SecretAuthentication(char[] value, String key) {
        this.key = Objects.requireNonNull(key, "authentication key cannot be null");
        if (key.length() == 0) {
            throw new IllegalArgumentException("authentication key cannot be empty");
        }
        this.secretHash = Arrays.hashCode(value) ^ KEYS[0].hashCode();
        this.value = this.xor(value);
    }

    private static char[] copy(char[] chars) {
        return chars != null ? (char[])chars.clone() : null;
    }

    private char[] xor(char[] chars) {
        if (chars != null) {
            int mask = System.identityHashCode(this);
            for (int i = 0; i < chars.length; ++i) {
                int key = KEYS[(i >> 1) % KEYS.length].hashCode();
                int n = i;
                chars[n] = (char)(chars[n] ^ ((i & 1) == 0 ? key & 0xFFFF : (key ^= mask) >>> 16));
            }
        }
        return chars;
    }

    private static void clear(char[] chars) {
        if (chars != null) {
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = '\u0000';
            }
        }
    }

    @Override
    public void fill(AuthenticationContext context, String key, Map<String, String> data2) {
        char[] secret = SecretAuthentication.copy(this.value);
        this.xor(secret);
        context.put(this.key, secret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void digest(AuthenticationDigest digest) {
        char[] secret = SecretAuthentication.copy(this.value);
        try {
            this.xor(secret);
            digest.update(this.key);
            digest.update(secret);
        }
        finally {
            SecretAuthentication.clear(secret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        SecretAuthentication that = (SecretAuthentication)obj;
        if (!Objects.equals(this.key, that.key) || this.secretHash != that.secretHash) {
            return false;
        }
        char[] secret = SecretAuthentication.copy(this.value);
        char[] thatSecret = SecretAuthentication.copy(that.value);
        try {
            this.xor(secret);
            that.xor(thatSecret);
            boolean bl = Arrays.equals(secret, thatSecret);
            return bl;
        }
        finally {
            SecretAuthentication.clear(secret);
            SecretAuthentication.clear(thatSecret);
        }
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.key.hashCode();
        hash = hash * 31 + this.secretHash;
        return hash;
    }

    public String toString() {
        return this.key + "=" + (this.value != null ? "***" : "null");
    }

    static {
        for (int i = 0; i < KEYS.length; ++i) {
            SecretAuthentication.KEYS[i] = new Object();
        }
    }
}

