/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.UnsolvableVersionConflictException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;

public final class NearestVersionSelector
extends ConflictResolver.VersionSelector {
    @Override
    public void selectVersion(ConflictResolver.ConflictContext context) throws RepositoryException {
        ConflictGroup group = new ConflictGroup();
        for (ConflictResolver.ConflictItem item : context.getItems()) {
            boolean hardConstraint;
            DependencyNode node = item.getNode();
            VersionConstraint constraint = node.getVersionConstraint();
            boolean backtrack = false;
            boolean bl = hardConstraint = constraint.getRange() != null;
            if (hardConstraint && group.constraints.add(constraint) && group.winner != null && !constraint.containsVersion(group.winner.getNode().getVersion())) {
                backtrack = true;
            }
            if (this.isAcceptable(group, node.getVersion())) {
                group.candidates.add(item);
                if (backtrack) {
                    this.backtrack(group, context);
                    continue;
                }
                if (group.winner != null && !this.isNearer(item, group.winner)) continue;
                group.winner = item;
                continue;
            }
            if (!backtrack) continue;
            this.backtrack(group, context);
        }
        context.setWinner(group.winner);
    }

    private void backtrack(ConflictGroup group, ConflictResolver.ConflictContext context) throws UnsolvableVersionConflictException {
        group.winner = null;
        Iterator<ConflictResolver.ConflictItem> it = group.candidates.iterator();
        while (it.hasNext()) {
            ConflictResolver.ConflictItem candidate = it.next();
            if (!this.isAcceptable(group, candidate.getNode().getVersion())) {
                it.remove();
                continue;
            }
            if (group.winner != null && !this.isNearer(candidate, group.winner)) continue;
            group.winner = candidate;
        }
        if (group.winner == null) {
            throw this.newFailure(context);
        }
    }

    private boolean isAcceptable(ConflictGroup group, Version version2) {
        for (VersionConstraint constraint : group.constraints) {
            if (constraint.containsVersion(version2)) continue;
            return false;
        }
        return true;
    }

    private boolean isNearer(ConflictResolver.ConflictItem item1, ConflictResolver.ConflictItem item2) {
        if (item1.isSibling(item2)) {
            return item1.getNode().getVersion().compareTo(item2.getNode().getVersion()) > 0;
        }
        return item1.getDepth() < item2.getDepth();
    }

    private UnsolvableVersionConflictException newFailure(final ConflictResolver.ConflictContext context) {
        DependencyFilter filter2 = new DependencyFilter(){

            @Override
            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                return context.isIncluded(node);
            }
        };
        PathRecordingDependencyVisitor visitor2 = new PathRecordingDependencyVisitor(filter2);
        context.getRoot().accept(visitor2);
        return new UnsolvableVersionConflictException(visitor2.getPaths());
    }

    static final class ConflictGroup {
        final Collection<VersionConstraint> constraints = new HashSet<VersionConstraint>();
        final Collection<ConflictResolver.ConflictItem> candidates = new ArrayList<ConflictResolver.ConflictItem>(64);
        ConflictResolver.ConflictItem winner;

        ConflictGroup() {
        }

        public String toString() {
            return String.valueOf(this.winner);
        }
    }
}

