/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.artifact;

import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;

public final class ArtifactIdUtils {
    private static final char SEP = ':';

    private ArtifactIdUtils() {
    }

    public static String toId(Artifact artifact) {
        String id2 = null;
        if (artifact != null) {
            id2 = ArtifactIdUtils.toId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion());
        }
        return id2;
    }

    public static String toId(String groupId, String artifactId, String extension, String classifier2, String version2) {
        StringBuilder buffer = ArtifactIdUtils.concat(groupId, artifactId, extension, classifier2);
        buffer.append(':');
        if (version2 != null) {
            buffer.append(version2);
        }
        return buffer.toString();
    }

    public static String toBaseId(Artifact artifact) {
        String id2 = null;
        if (artifact != null) {
            id2 = ArtifactIdUtils.toId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getBaseVersion());
        }
        return id2;
    }

    public static String toVersionlessId(Artifact artifact) {
        String id2 = null;
        if (artifact != null) {
            id2 = ArtifactIdUtils.toVersionlessId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier());
        }
        return id2;
    }

    public static String toVersionlessId(String groupId, String artifactId, String extension, String classifier2) {
        return ArtifactIdUtils.concat(groupId, artifactId, extension, classifier2).toString();
    }

    private static StringBuilder concat(String groupId, String artifactId, String extension, String classifier2) {
        StringBuilder buffer = new StringBuilder(128);
        if (groupId != null) {
            buffer.append(groupId);
        }
        buffer.append(':');
        if (artifactId != null) {
            buffer.append(artifactId);
        }
        buffer.append(':');
        if (extension != null) {
            buffer.append(extension);
        }
        if (classifier2 != null && classifier2.length() > 0) {
            buffer.append(':').append(classifier2);
        }
        return buffer;
    }

    public static boolean equalsId(Artifact artifact1, Artifact artifact2) {
        if (artifact1 == null || artifact2 == null) {
            return false;
        }
        if (!Objects.equals(artifact1.getArtifactId(), artifact2.getArtifactId())) {
            return false;
        }
        if (!Objects.equals(artifact1.getGroupId(), artifact2.getGroupId())) {
            return false;
        }
        if (!Objects.equals(artifact1.getExtension(), artifact2.getExtension())) {
            return false;
        }
        if (!Objects.equals(artifact1.getClassifier(), artifact2.getClassifier())) {
            return false;
        }
        return Objects.equals(artifact1.getVersion(), artifact2.getVersion());
    }

    public static boolean equalsBaseId(Artifact artifact1, Artifact artifact2) {
        if (artifact1 == null || artifact2 == null) {
            return false;
        }
        if (!Objects.equals(artifact1.getArtifactId(), artifact2.getArtifactId())) {
            return false;
        }
        if (!Objects.equals(artifact1.getGroupId(), artifact2.getGroupId())) {
            return false;
        }
        if (!Objects.equals(artifact1.getExtension(), artifact2.getExtension())) {
            return false;
        }
        if (!Objects.equals(artifact1.getClassifier(), artifact2.getClassifier())) {
            return false;
        }
        return Objects.equals(artifact1.getBaseVersion(), artifact2.getBaseVersion());
    }

    public static boolean equalsVersionlessId(Artifact artifact1, Artifact artifact2) {
        if (artifact1 == null || artifact2 == null) {
            return false;
        }
        if (!Objects.equals(artifact1.getArtifactId(), artifact2.getArtifactId())) {
            return false;
        }
        if (!Objects.equals(artifact1.getGroupId(), artifact2.getGroupId())) {
            return false;
        }
        if (!Objects.equals(artifact1.getExtension(), artifact2.getExtension())) {
            return false;
        }
        return Objects.equals(artifact1.getClassifier(), artifact2.getClassifier());
    }
}

