/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.RepositorySystemSession;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static Object getObject(Map<?, ?> properties2, Object defaultValue, String ... keys2) {
        for (String key : keys2) {
            Object value = properties2.get(key);
            if (value == null) continue;
            return value;
        }
        return defaultValue;
    }

    public static Object getObject(RepositorySystemSession session, Object defaultValue, String ... keys2) {
        return ConfigUtils.getObject(session.getConfigProperties(), defaultValue, keys2);
    }

    public static String getString(Map<?, ?> properties2, String defaultValue, String ... keys2) {
        for (String key : keys2) {
            Object value = properties2.get(key);
            if (!(value instanceof String)) continue;
            return (String)value;
        }
        return defaultValue;
    }

    public static String getString(RepositorySystemSession session, String defaultValue, String ... keys2) {
        return ConfigUtils.getString(session.getConfigProperties(), defaultValue, keys2);
    }

    public static int getInteger(Map<?, ?> properties2, int defaultValue, String ... keys2) {
        for (String key : keys2) {
            Object value = properties2.get(key);
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            try {
                return Integer.valueOf((String)value);
            }
            catch (Exception exception) {
            }
        }
        return defaultValue;
    }

    public static int getInteger(RepositorySystemSession session, int defaultValue, String ... keys2) {
        return ConfigUtils.getInteger(session.getConfigProperties(), defaultValue, keys2);
    }

    public static long getLong(Map<?, ?> properties2, long defaultValue, String ... keys2) {
        for (String key : keys2) {
            Object value = properties2.get(key);
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            try {
                return Long.valueOf((String)value);
            }
            catch (Exception exception) {
            }
        }
        return defaultValue;
    }

    public static long getLong(RepositorySystemSession session, long defaultValue, String ... keys2) {
        return ConfigUtils.getLong(session.getConfigProperties(), defaultValue, keys2);
    }

    public static float getFloat(Map<?, ?> properties2, float defaultValue, String ... keys2) {
        for (String key : keys2) {
            Object value = properties2.get(key);
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            try {
                return Float.valueOf((String)value).floatValue();
            }
            catch (Exception exception) {
            }
        }
        return defaultValue;
    }

    public static float getFloat(RepositorySystemSession session, float defaultValue, String ... keys2) {
        return ConfigUtils.getFloat(session.getConfigProperties(), defaultValue, keys2);
    }

    public static boolean getBoolean(Map<?, ?> properties2, boolean defaultValue, String ... keys2) {
        for (String key : keys2) {
            Object value = properties2.get(key);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (!(value instanceof String)) continue;
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public static boolean getBoolean(RepositorySystemSession session, boolean defaultValue, String ... keys2) {
        return ConfigUtils.getBoolean(session.getConfigProperties(), defaultValue, keys2);
    }

    public static List<?> getList(Map<?, ?> properties2, List<?> defaultValue, String ... keys2) {
        for (String key : keys2) {
            Object value = properties2.get(key);
            if (value instanceof List) {
                return (List)value;
            }
            if (!(value instanceof Collection)) continue;
            return Collections.unmodifiableList(new ArrayList((Collection)value));
        }
        return defaultValue;
    }

    public static List<?> getList(RepositorySystemSession session, List<?> defaultValue, String ... keys2) {
        return ConfigUtils.getList(session.getConfigProperties(), defaultValue, keys2);
    }

    public static Map<?, ?> getMap(Map<?, ?> properties2, Map<?, ?> defaultValue, String ... keys2) {
        for (String key : keys2) {
            Object value = properties2.get(key);
            if (!(value instanceof Map)) continue;
            return (Map)value;
        }
        return defaultValue;
    }

    public static Map<?, ?> getMap(RepositorySystemSession session, Map<?, ?> defaultValue, String ... keys2) {
        return ConfigUtils.getMap(session.getConfigProperties(), defaultValue, keys2);
    }
}

