/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private transient EntryImpl[] _entries;
    private transient int _capacity;
    private transient int _mask;
    private transient EntryImpl _poolFirst;
    private transient EntryImpl _mapFirst;
    private transient EntryImpl _mapLast;
    private transient int _size;
    private transient Values _values;
    private transient EntrySet _entrySet;
    private transient KeySet _keySet;

    public FastMap() {
        this.initialize(256);
    }

    public FastMap(Map map2) {
        int capacity = map2 instanceof FastMap ? ((FastMap)map2).capacity() : map2.size();
        this.initialize(capacity);
        this.putAll(map2);
    }

    public FastMap(int capacity) {
        this.initialize(capacity);
    }

    @Override
    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._capacity;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        EntryImpl entry2 = this._entries[FastMap.keyHash(key) & this._mask];
        while (entry2 != null) {
            if (key.equals(entry2._key)) {
                return true;
            }
            entry2 = entry2._next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        EntryImpl entry2 = this._mapFirst;
        while (entry2 != null) {
            if (value.equals(entry2._value)) {
                return true;
            }
            entry2 = entry2._after;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        EntryImpl entry2 = this._entries[FastMap.keyHash(key) & this._mask];
        while (entry2 != null) {
            if (key.equals(entry2._key)) {
                return (V)entry2._value;
            }
            entry2 = entry2._next;
        }
        return null;
    }

    public Map.Entry getEntry(Object key) {
        EntryImpl entry2 = this._entries[FastMap.keyHash(key) & this._mask];
        while (entry2 != null) {
            if (key.equals(entry2._key)) {
                return entry2;
            }
            entry2 = entry2._next;
        }
        return null;
    }

    @Override
    public Object put(Object key, Object value) {
        EntryImpl entry2 = this._entries[FastMap.keyHash(key) & this._mask];
        while (entry2 != null) {
            if (key.equals(entry2._key)) {
                Object prevValue = entry2._value;
                entry2._value = value;
                return prevValue;
            }
            entry2 = entry2._next;
        }
        this.addEntry(key, value);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        for (Map.Entry<K, V> entry2 : map2.entrySet()) {
            this.addEntry(entry2.getKey(), entry2.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        EntryImpl entry2 = this._entries[FastMap.keyHash(key) & this._mask];
        while (entry2 != null) {
            if (key.equals(entry2._key)) {
                Object prevValue = entry2._value;
                this.removeEntry(entry2);
                return (V)prevValue;
            }
            entry2 = entry2._next;
        }
        return null;
    }

    @Override
    public void clear() {
        EntryImpl entry2 = this._mapFirst;
        while (entry2 != null) {
            entry2._key = null;
            entry2._value = null;
            entry2._before = null;
            entry2._next = null;
            if (entry2._previous == null) {
                this._entries[((EntryImpl)entry2)._index] = null;
            } else {
                entry2._previous = null;
            }
            entry2 = entry2._after;
        }
        if (this._mapLast != null) {
            this._mapLast._after = this._poolFirst;
            this._poolFirst = this._mapFirst;
            this._mapFirst = null;
            this._mapLast = null;
            this._size = 0;
            this.sizeChanged();
        }
    }

    public void setCapacity(int newCapacity) {
        int tableLength;
        EntryImpl entry2;
        int i;
        if (newCapacity > this._capacity) {
            for (i = this._capacity; i < newCapacity; ++i) {
                entry2 = new EntryImpl();
                entry2._after = this._poolFirst;
                this._poolFirst = entry2;
            }
        } else if (newCapacity < this._capacity) {
            for (i = newCapacity; i < this._capacity && this._poolFirst != null; ++i) {
                entry2 = this._poolFirst;
                this._poolFirst = entry2._after;
                entry2._after = null;
            }
        }
        for (tableLength = 16; tableLength < newCapacity; tableLength <<= 1) {
        }
        if (this._entries.length != tableLength) {
            this._entries = new EntryImpl[tableLength];
            this._mask = tableLength - 1;
            entry2 = this._mapFirst;
            while (entry2 != null) {
                int index = FastMap.keyHash(entry2._key) & this._mask;
                entry2._index = index;
                entry2._previous = null;
                EntryImpl next = this._entries[index];
                entry2._next = next;
                if (next != null) {
                    next._previous = entry2;
                }
                this._entries[index] = entry2;
                entry2 = entry2._after;
            }
        }
        this._capacity = newCapacity;
    }

    public Object clone() {
        try {
            FastMap clone = (FastMap)super.clone();
            clone.initialize(this._capacity);
            clone.putAll(this);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Map) {
            Map that = (Map)obj;
            if (this.size() == that.size()) {
                EntryImpl entry2 = this._mapFirst;
                while (entry2 != null) {
                    if (!that.entrySet().contains(entry2)) {
                        return false;
                    }
                    entry2 = entry2._after;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 0;
        EntryImpl entry2 = this._mapFirst;
        while (entry2 != null) {
            code += entry2.hashCode();
            entry2 = entry2._after;
        }
        return code;
    }

    public String toString() {
        return this.entrySet().toString();
    }

    @Override
    public Collection values() {
        return this._values;
    }

    @Override
    public Set entrySet() {
        return this._entrySet;
    }

    @Override
    public Set keySet() {
        return this._keySet;
    }

    protected void sizeChanged() {
        if (this.size() > this.capacity()) {
            this.setCapacity(this.capacity() * 2);
        }
    }

    private static int keyHash(Object key) {
        int hashCode2 = key.hashCode();
        hashCode2 += ~(hashCode2 << 9);
        hashCode2 ^= hashCode2 >>> 14;
        hashCode2 += hashCode2 << 4;
        hashCode2 ^= hashCode2 >>> 10;
        return hashCode2;
    }

    private void addEntry(Object key, Object value) {
        EntryImpl entry2 = this._poolFirst;
        if (entry2 != null) {
            this._poolFirst = entry2._after;
            entry2._after = null;
        } else {
            entry2 = new EntryImpl();
        }
        entry2._key = key;
        entry2._value = value;
        int index = FastMap.keyHash(key) & this._mask;
        entry2._index = index;
        EntryImpl next = this._entries[index];
        entry2._next = next;
        if (next != null) {
            next._previous = entry2;
        }
        this._entries[index] = entry2;
        if (this._mapLast != null) {
            entry2._before = this._mapLast;
            this._mapLast._after = entry2;
        } else {
            this._mapFirst = entry2;
        }
        this._mapLast = entry2;
        ++this._size;
        this.sizeChanged();
    }

    private void removeEntry(EntryImpl entry2) {
        EntryImpl previous = entry2._previous;
        EntryImpl next = entry2._next;
        if (previous != null) {
            previous._next = next;
            entry2._previous = null;
        } else {
            this._entries[((EntryImpl)entry2)._index] = next;
        }
        if (next != null) {
            next._previous = previous;
            entry2._next = null;
        }
        EntryImpl before = entry2._before;
        EntryImpl after = entry2._after;
        if (before != null) {
            before._after = after;
            entry2._before = null;
        } else {
            this._mapFirst = after;
        }
        if (after != null) {
            after._before = before;
        } else {
            this._mapLast = before;
        }
        entry2._key = null;
        entry2._value = null;
        entry2._after = this._poolFirst;
        this._poolFirst = entry2;
        --this._size;
        this.sizeChanged();
    }

    private void initialize(int capacity) {
        int tableLength;
        for (tableLength = 16; tableLength < capacity; tableLength <<= 1) {
        }
        this._entries = new EntryImpl[tableLength];
        this._mask = tableLength - 1;
        this._capacity = capacity;
        this._size = 0;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        this._poolFirst = null;
        this._mapFirst = null;
        this._mapLast = null;
        for (int i = 0; i < capacity; ++i) {
            EntryImpl entry2 = new EntryImpl();
            entry2._after = this._poolFirst;
            this._poolFirst = entry2;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int capacity = stream.readInt();
        this.initialize(capacity);
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            this.addEntry(key, value);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this._capacity);
        stream.writeInt(this._size);
        int count2 = 0;
        EntryImpl entry2 = this._mapFirst;
        while (entry2 != null) {
            stream.writeObject(entry2._key);
            stream.writeObject(entry2._value);
            ++count2;
            entry2 = entry2._after;
        }
        if (count2 != this._size) {
            throw new IOException("FastMap Corrupted");
        }
    }

    private static final class EntryImpl<K, V>
    implements Map.Entry<K, V> {
        private K _key;
        private V _value;
        private int _index;
        private EntryImpl _previous;
        private EntryImpl _next;
        private EntryImpl _before;
        private EntryImpl _after;

        private EntryImpl() {
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public V setValue(V value) {
            V old = this._value;
            this._value = value;
            return old;
        }

        @Override
        public boolean equals(Object that) {
            if (that instanceof Map.Entry) {
                Map.Entry entry2 = (Map.Entry)that;
                return this._key.equals(entry2.getKey()) && (this._value != null ? this._value.equals(entry2.getValue()) : entry2.getValue() == null);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this._key.hashCode() ^ (this._value != null ? this._value.hashCode() : 0);
        }

        public String toString() {
            return this._key + "=" + this._value;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before._key;
                }
            };
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public boolean contains(Object obj) {
            return FastMap.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return FastMap.this.remove(obj) != null;
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before;
                }
            };
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public boolean contains(Object obj) {
            if (obj instanceof Map.Entry) {
                Map.Entry entry2 = (Map.Entry)obj;
                Map.Entry mapEntry = FastMap.this.getEntry(entry2.getKey());
                return entry2.equals(mapEntry);
            }
            return false;
        }

        @Override
        public boolean remove(Object obj) {
            Map.Entry entry2;
            EntryImpl mapEntry;
            if (obj instanceof Map.Entry && (mapEntry = (EntryImpl)FastMap.this.getEntry((entry2 = (Map.Entry)obj).getKey())) != null && entry2.getValue().equals(mapEntry._value)) {
                FastMap.this.removeEntry(mapEntry);
                return true;
            }
            return false;
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before._value;
                }
            };
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public boolean contains(Object o) {
            return FastMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }
    }
}

