/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.plexus.Hints;

public class ComponentDescriptor<T> {
    private String role;
    private String hint = "default";
    private String description = "";
    private String instantiationStrategy = "singleton";
    private String implementation;
    private ClassRealm classRealm;
    private Class<?> implementationClass;
    private String componentComposer;
    private String componentConfigurator;
    private String componentFactory;
    private List<ComponentRequirement> requirements = Collections.emptyList();
    private PlexusConfiguration configuration;
    private String alias;
    private String version;
    private String componentType;
    private String componentProfile;
    private String lifecycleHandler;
    private boolean isolatedRealm;

    public ComponentDescriptor() {
    }

    public ComponentDescriptor(Class<T> implementationClass, ClassRealm classRealm) {
        this.setImplementationClass(implementationClass);
        this.classRealm = classRealm;
    }

    public final void setRole(String role) {
        this.role = role;
    }

    public final void setRoleClass(Class<?> roleClass) {
        this.role = roleClass.getName();
    }

    public final void setRoleHint(String hint) {
        this.hint = Hints.canonicalHint(hint);
    }

    public final void setDescription(String description2) {
        this.description = description2 != null ? description2 : "";
    }

    public final void setInstantiationStrategy(String instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    public final void setImplementation(String implementation) {
        this.implementation = implementation;
        this.implementationClass = null;
    }

    public final void setRealm(ClassRealm classRealm) {
        this.classRealm = classRealm;
        this.implementationClass = null;
    }

    public final void setImplementationClass(Class implementationClass) {
        this.implementationClass = implementationClass;
        this.implementation = implementationClass.getName();
    }

    public final void setComponentComposer(String componentComposer) {
        this.componentComposer = componentComposer;
    }

    public final void setComponentConfigurator(String componentConfigurator) {
        this.componentConfigurator = componentConfigurator;
    }

    public final void setComponentFactory(String componentFactory) {
        this.componentFactory = componentFactory;
    }

    public final void addRequirement(ComponentRequirement requirement) {
        if (this.requirements.isEmpty()) {
            this.requirements = new ArrayList<ComponentRequirement>();
        }
        this.requirements.add(requirement);
    }

    public final void setConfiguration(PlexusConfiguration configuration) {
        this.configuration = configuration;
    }

    public final void setAlias(String alias) {
        this.alias = alias;
    }

    public final void setVersion(String version2) {
        this.version = version2;
    }

    public final void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public final void setComponentProfile(String componentProfile) {
        this.componentProfile = componentProfile;
    }

    public final void setLifecycleHandler(String lifecycleHandler) {
        this.lifecycleHandler = lifecycleHandler;
    }

    public final void setIsolatedRealm(boolean isolatedRealm) {
        this.isolatedRealm = isolatedRealm;
    }

    public String getRole() {
        return this.role;
    }

    public final Class<T> getRoleClass() {
        try {
            return this.classRealm.loadClass(this.getRole());
        }
        catch (Exception e) {
            throw new TypeNotPresentException(this.getRole(), e);
        }
        catch (LinkageError e) {
            throw new TypeNotPresentException(this.getRole(), e);
        }
    }

    public String getRoleHint() {
        return this.hint;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    public final String getImplementation() {
        return this.implementation;
    }

    public final ClassRealm getRealm() {
        return this.classRealm;
    }

    public final Class<T> getImplementationClass() {
        if (this.implementationClass == null && this.classRealm != null) {
            try {
                this.implementationClass = this.classRealm.loadClass(this.implementation);
            }
            catch (Exception e) {
                throw new TypeNotPresentException(this.implementation, e);
            }
            catch (LinkageError e) {
                throw new TypeNotPresentException(this.implementation, e);
            }
        }
        return this.implementationClass;
    }

    public final String getComponentComposer() {
        return this.componentComposer;
    }

    public final String getComponentConfigurator() {
        return this.componentConfigurator;
    }

    public final String getComponentFactory() {
        return this.componentFactory;
    }

    public final List<ComponentRequirement> getRequirements() {
        return Collections.unmodifiableList(this.requirements);
    }

    public final boolean hasConfiguration() {
        return this.configuration != null;
    }

    public final PlexusConfiguration getConfiguration() {
        return this.configuration;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final String getVersion() {
        return this.version;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public final String getComponentProfile() {
        return this.componentProfile;
    }

    public final String getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    public final boolean isIsolatedRealm() {
        return this.isolatedRealm;
    }

    public final String getHumanReadableKey() {
        return "role: '" + this.getRole() + "', implementation: '" + this.implementation + "', role hint: '" + this.getRoleHint() + "'";
    }

    public final String toString() {
        return String.valueOf(this.getClass().getName()) + " [role: '" + this.getRole() + "', hint: '" + this.getRoleHint() + "', realm: " + this.classRealm + "]";
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof ComponentDescriptor) {
            ComponentDescriptor rhsDescriptor = (ComponentDescriptor)rhs;
            return ComponentDescriptor.equals(this.getRole(), rhsDescriptor.getRole()) && ComponentDescriptor.equals(this.getRoleHint(), rhsDescriptor.getRoleHint()) && ComponentDescriptor.equals(this.classRealm, rhsDescriptor.classRealm);
        }
        return false;
    }

    public int hashCode() {
        return ((527 + ComponentDescriptor.hash(this.getRole())) * 31 + ComponentDescriptor.hash(this.getRoleHint())) * 31 + ComponentDescriptor.hash(this.classRealm);
    }

    private static final <T> boolean equals(T lhs, T rhs) {
        return lhs != null ? lhs.equals(rhs) : rhs == null;
    }

    private static final int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

