/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.special;

import java.util.ArrayDeque;
import java.util.Deque;
import org.codehaus.classworlds.ClassRealmAdapter;
import org.codehaus.classworlds.ClassRealmReverseAdapter;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public final class ClassRealmConverter
extends AbstractConfigurationConverter {
    private static ThreadLocal<Object> context = new ThreadLocal();
    private final ClassRealm realm;

    public ClassRealmConverter(ClassRealm realm) {
        this.realm = realm;
    }

    public ClassRealmConverter(org.codehaus.classworlds.ClassRealm realm) {
        this.realm = ClassRealmReverseAdapter.getInstance((org.codehaus.classworlds.ClassRealm)realm);
    }

    public ClassRealmConverter() {
        this.realm = null;
    }

    public static void pushContextRealm(ClassRealm realm) {
        Object holder = context.get();
        if (holder == null) {
            context.set(realm);
        } else if (holder instanceof ClassRealm) {
            ArrayDeque<ClassRealm> stack = new ArrayDeque<ClassRealm>();
            stack.add(realm);
            stack.add((ClassRealm)holder);
            context.set(stack);
        } else if (holder instanceof Deque) {
            ((Deque)holder).addFirst(realm);
        }
    }

    public static void popContextRealm() {
        Object holder = context.get();
        if (holder instanceof ClassRealm) {
            context.remove();
        } else if (holder instanceof Deque) {
            Deque stack = (Deque)holder;
            if (stack.size() == 2) {
                context.set(stack.peekLast());
            } else {
                stack.removeFirst();
            }
        }
    }

    public ClassRealm peekContextRealm() {
        Object holder = context.get();
        if (holder instanceof ClassRealm) {
            return (ClassRealm)holder;
        }
        if (holder instanceof Deque) {
            return (ClassRealm)((Deque)holder).getFirst();
        }
        return this.realm;
    }

    @Override
    public boolean canConvert(Class<?> type2) {
        return ClassRealm.class.isAssignableFrom(type2) || org.codehaus.classworlds.ClassRealm.class.isAssignableFrom(type2);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object result2 = this.fromExpression(configuration, evaluator, type2);
        if (result2 == null) {
            result2 = this.peekContextRealm();
        }
        if (!ClassRealm.class.isAssignableFrom(type2) && result2 instanceof ClassRealm) {
            result2 = ClassRealmAdapter.getInstance((ClassRealm)((ClassRealm)result2));
        }
        return result2;
    }
}

