/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.composite.AbstractCollectionConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class CollectionConverter
extends AbstractCollectionConverter
implements ParameterizedConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type2) {
        return Collection.class.isAssignableFrom(type2) && !Map.class.isAssignableFrom(type2);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        return this.fromConfiguration(lookup, configuration, type2, null, enclosingType, loader, evaluator, listener);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type2, Type[] typeArguments, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator);
        if (type2.isInstance(value)) {
            return value;
        }
        try {
            Collection<Object> elements;
            Class<?> elementType = CollectionConverter.findElementType(typeArguments);
            if (value == null) {
                elements = this.fromChildren(lookup, configuration, type2, enclosingType, loader, evaluator, listener, elementType);
            } else if (value instanceof String) {
                PlexusConfiguration xml = CollectionConverter.csvToXml(configuration, (String)value);
                elements = this.fromChildren(lookup, xml, type2, enclosingType, loader, evaluator, listener, elementType);
            } else if (value instanceof Object[]) {
                elements = this.instantiateCollection(configuration, type2, loader);
                Collections.addAll(elements, (Object[])value);
            } else {
                this.failIfNotTypeCompatible(value, type2, configuration);
                elements = Collections.emptyList();
            }
            return elements;
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new ComponentConfigurationException(configuration, "Cannot store value into collection", e);
        }
    }

    @Override
    protected final Collection<Object> instantiateCollection(PlexusConfiguration configuration, Class<?> type2, ClassLoader loader) throws ComponentConfigurationException {
        Class<?> implType = this.getClassForImplementationHint(type2, configuration, loader);
        if (implType == null || Modifier.isAbstract(implType.getModifiers())) {
            if (Set.class.isAssignableFrom(type2)) {
                if (SortedSet.class.isAssignableFrom(type2)) {
                    return new TreeSet<Object>();
                }
                return new HashSet<Object>();
            }
            return new ArrayList<Object>();
        }
        Object impl = this.instantiateObject(implType);
        this.failIfNotTypeCompatible(impl, type2, configuration);
        return (Collection)impl;
    }

    private static Class<?> findElementType(Type[] typeArguments) {
        if (typeArguments != null && typeArguments.length > 0 && typeArguments[0] instanceof Class) {
            return (Class)typeArguments[0];
        }
        return Object.class;
    }
}

