/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.basic;

import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class EnumConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type2) {
        return type2.isEnum();
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        if (configuration.getChildCount() > 0) {
            throw new ComponentConfigurationException("Basic element '" + configuration.getName() + "' must not contain child elements");
        }
        Object result2 = this.fromExpression(configuration, evaluator);
        if (result2 instanceof String) {
            try {
                result2 = Enum.valueOf(type2, (String)result2);
            }
            catch (RuntimeException e) {
                throw new ComponentConfigurationException("Cannot convert '" + result2 + "' to Enum", (Throwable)e);
            }
        }
        return result2;
    }
}

