/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaxToolsCompiler {
    static final JavaCompiler COMPILER = ToolProvider.getSystemJavaCompiler();
    private static List<JavaCompiler> JAVA_COMPILERS = new CopyOnWriteArrayList<JavaCompiler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JavaCompiler getJavaCompiler(CompilerConfiguration compilerConfiguration) {
        switch (compilerConfiguration.getCompilerReuseStrategy()) {
            case AlwaysNew: {
                return ToolProvider.getSystemJavaCompiler();
            }
            case ReuseCreated: {
                List<JavaCompiler> list2 = JAVA_COMPILERS;
                synchronized (list2) {
                    if (JAVA_COMPILERS.size() > 0) {
                        JavaCompiler javaCompiler = JAVA_COMPILERS.get(0);
                        JAVA_COMPILERS.remove(javaCompiler);
                        return javaCompiler;
                    }
                }
                JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
                return javaCompiler;
            }
        }
        return COMPILER;
    }

    static void releaseJavaCompiler(JavaCompiler javaCompiler, CompilerConfiguration compilerConfiguration) {
        if (javaCompiler == null) {
            return;
        }
        if (compilerConfiguration.getCompilerReuseStrategy() == CompilerConfiguration.CompilerReuseStrategy.ReuseCreated) {
            JAVA_COMPILERS.add(javaCompiler);
        }
    }

    static CompilerResult compileInProcess(String[] args2, CompilerConfiguration config, String[] sourceFiles) throws CompilerException {
        JavaCompiler compiler = JavaxToolsCompiler.getJavaCompiler(config);
        try {
            if (compiler == null) {
                CompilerMessage message = new CompilerMessage("No compiler is provided in this environment. Perhaps you are running on a JRE rather than a JDK?", CompilerMessage.Kind.ERROR);
                CompilerResult compilerResult = new CompilerResult(false, Collections.singletonList(message));
                return compilerResult;
            }
            String sourceEncoding = config.getSourceEncoding();
            Charset sourceCharset = sourceEncoding == null ? null : Charset.forName(sourceEncoding);
            DiagnosticCollector collector2 = new DiagnosticCollector();
            StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(collector2, null, sourceCharset);
            Iterable<? extends JavaFileObject> fileObjects = standardFileManager.getJavaFileObjectsFromStrings(Arrays.asList(sourceFiles));
            List<String> arguments2 = Arrays.asList(args2);
            JavaCompiler.CompilationTask task = compiler.getTask(null, standardFileManager, collector2, arguments2, null, fileObjects);
            Boolean result2 = task.call();
            ArrayList<CompilerMessage> compilerMsgs = new ArrayList<CompilerMessage>();
            for (Diagnostic diagnostic : collector2.getDiagnostics()) {
                CompilerMessage.Kind kind = JavaxToolsCompiler.convertKind(diagnostic);
                String baseMessage = diagnostic.getMessage(null);
                if (baseMessage == null) continue;
                JavaFileObject source = (JavaFileObject)diagnostic.getSource();
                String longFileName = source == null ? null : source.toUri().getPath();
                String shortFileName = source == null ? null : source.getName();
                String formattedMessage = baseMessage;
                int lineNumber = Math.max(0, (int)diagnostic.getLineNumber());
                int columnNumber = Math.max(0, (int)diagnostic.getColumnNumber());
                if (source != null && lineNumber > 0) {
                    String possibleTrimming = longFileName + ":" + lineNumber + ": ";
                    if (formattedMessage.startsWith(possibleTrimming)) {
                        formattedMessage = formattedMessage.substring(possibleTrimming.length());
                    } else {
                        possibleTrimming = shortFileName + ":" + lineNumber + ": ";
                        if (formattedMessage.startsWith(possibleTrimming)) {
                            formattedMessage = formattedMessage.substring(possibleTrimming.length());
                        }
                    }
                }
                compilerMsgs.add(new CompilerMessage(longFileName, kind, lineNumber, columnNumber, lineNumber, columnNumber, formattedMessage));
            }
            if (result2 != Boolean.TRUE && compilerMsgs.isEmpty()) {
                compilerMsgs.add(new CompilerMessage("An unknown compilation problem occurred", CompilerMessage.Kind.ERROR));
            }
            CompilerResult compilerResult = new CompilerResult(result2, compilerMsgs);
            return compilerResult;
        }
        catch (Exception e) {
            throw new CompilerException(e.getMessage(), e);
        }
        finally {
            JavaxToolsCompiler.releaseJavaCompiler(compiler, config);
        }
    }

    public static CompilerMessage.Kind convertKind(Diagnostic<? extends JavaFileObject> diagnostic) {
        CompilerMessage.Kind kind;
        switch (diagnostic.getKind()) {
            case ERROR: {
                kind = CompilerMessage.Kind.ERROR;
                break;
            }
            case WARNING: {
                kind = CompilerMessage.Kind.WARNING;
                break;
            }
            case MANDATORY_WARNING: {
                kind = CompilerMessage.Kind.MANDATORY_WARNING;
                break;
            }
            case NOTE: {
                kind = CompilerMessage.Kind.NOTE;
                break;
            }
            default: {
                kind = CompilerMessage.Kind.OTHER;
            }
        }
        return kind;
    }
}

