/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.javac.JavaxToolsCompiler;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavacCompiler
extends AbstractCompiler {
    private static final String[] WARNING_PREFIXES = new String[]{"warning: ", "\u8b66\u544a: ", "\u8b66\u544a\uff1a "};
    private static final String[] NOTE_PREFIXES = new String[]{"Note: ", "\u6ce8: ", "\u6ce8\u610f\uff1a "};
    private static final Object LOCK = new Object();
    private static final String JAVAC_CLASSNAME = "com.sun.tools.javac.Main";
    private static volatile Class<?> JAVAC_CLASS;
    private List<Class<?>> javaccClasses = new CopyOnWriteArrayList();

    public JavacCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    @Override
    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        CompilerResult result2;
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = JavacCompiler.getSourceFiles(config)) == null || sourceFiles.length == 0) {
            return new CompilerResult();
        }
        if (this.getLogger() != null && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Compiling " + sourceFiles.length + " " + "source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        }
        String[] args2 = JavacCompiler.buildCompilerArguments(config, sourceFiles);
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (StringUtils.isEmpty(executable)) {
                try {
                    executable = JavacCompiler.getJavacExecutable();
                }
                catch (IOException e) {
                    this.getLogger().warn("Unable to autodetect 'javac' path, using 'javac' from the environment.");
                    executable = "javac";
                }
            }
            result2 = this.compileOutOfProcess(config, executable, args2);
        } else {
            result2 = JavacCompiler.isJava16() && !config.isForceJavacCompilerUse() ? JavaxToolsCompiler.compileInProcess(args2, config, sourceFiles) : this.compileInProcess(args2, config);
        }
        return result2;
    }

    protected static boolean isJava16() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("javax.tools.ToolProvider");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return JavacCompiler.buildCompilerArguments(config, JavacCompiler.getSourceFiles(config));
    }

    public static String[] buildCompilerArguments(CompilerConfiguration config, String[] sourceFiles) {
        List<String> sourceLocations;
        ArrayList<String> args2 = new ArrayList<String>();
        File destinationDir = new File(config.getOutputLocation());
        args2.add("-d");
        args2.add(destinationDir.getAbsolutePath());
        List<String> classpathEntries = config.getClasspathEntries();
        if (classpathEntries != null && !classpathEntries.isEmpty()) {
            args2.add("-classpath");
            args2.add(JavacCompiler.getPathString(classpathEntries));
        }
        if ((sourceLocations = config.getSourceLocations()) != null && !sourceLocations.isEmpty()) {
            args2.add("-sourcepath");
            args2.add(JavacCompiler.getPathString(sourceLocations));
        }
        if (!JavacCompiler.isJava16() || config.isForceJavacCompilerUse() || config.isFork()) {
            args2.addAll(Arrays.asList(sourceFiles));
        }
        if (!JavacCompiler.isPreJava16(config)) {
            if (config.getGeneratedSourcesDirectory() != null) {
                config.getGeneratedSourcesDirectory().mkdirs();
                args2.add("-s");
                args2.add(config.getGeneratedSourcesDirectory().getAbsolutePath());
            }
            if (config.getProc() != null) {
                args2.add("-proc:" + config.getProc());
            }
            if (config.getAnnotationProcessors() != null) {
                args2.add("-processor");
                String[] procs = config.getAnnotationProcessors();
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < procs.length; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(procs[i]);
                }
                args2.add(buffer.toString());
            }
            if (config.getProcessorPathEntries() != null && !config.getProcessorPathEntries().isEmpty()) {
                args2.add("-processorpath");
                args2.add(JavacCompiler.getPathString(config.getProcessorPathEntries()));
            }
        }
        if (config.isOptimize()) {
            args2.add("-O");
        }
        if (config.isDebug()) {
            if (StringUtils.isNotEmpty(config.getDebugLevel())) {
                args2.add("-g:" + config.getDebugLevel());
            } else {
                args2.add("-g");
            }
        }
        if (config.isVerbose()) {
            args2.add("-verbose");
        }
        if (config.isShowDeprecation()) {
            args2.add("-deprecation");
            config.setShowWarnings(true);
        }
        if (!config.isShowWarnings()) {
            args2.add("-nowarn");
        }
        if (StringUtils.isEmpty(config.getTargetVersion())) {
            args2.add("-target");
            args2.add("1.1");
        } else {
            args2.add("-target");
            args2.add(config.getTargetVersion());
        }
        if (!JavacCompiler.suppressSource(config) && StringUtils.isEmpty(config.getSourceVersion())) {
            args2.add("-source");
            args2.add("1.3");
        } else if (!JavacCompiler.suppressSource(config)) {
            args2.add("-source");
            args2.add(config.getSourceVersion());
        }
        if (!JavacCompiler.suppressEncoding(config) && !StringUtils.isEmpty(config.getSourceEncoding())) {
            args2.add("-encoding");
            args2.add(config.getSourceEncoding());
        }
        for (Map.Entry<String, String> entry2 : config.getCustomCompilerArgumentsAsMap().entrySet()) {
            String key = entry2.getKey();
            if (StringUtils.isEmpty(key) || key.startsWith("-J")) continue;
            args2.add(key);
            String value = entry2.getValue();
            if (StringUtils.isEmpty(value)) continue;
            args2.add(value);
        }
        return args2.toArray(new String[args2.size()]);
    }

    private static boolean isPreJava14(CompilerConfiguration config) {
        String v = config.getCompilerVersion();
        if (v == null) {
            return false;
        }
        return v.startsWith("1.3") || v.startsWith("1.2") || v.startsWith("1.1") || v.startsWith("1.0");
    }

    private static boolean isPreJava16(CompilerConfiguration config) {
        String v = config.getCompilerVersion();
        if (v == null) {
            String s2 = config.getSourceVersion();
            if (s2 == null) {
                return true;
            }
            return s2.startsWith("1.5") || s2.startsWith("1.4") || s2.startsWith("1.3") || s2.startsWith("1.2") || s2.startsWith("1.1") || s2.startsWith("1.0");
        }
        return v.startsWith("1.5") || v.startsWith("1.4") || v.startsWith("1.3") || v.startsWith("1.2") || v.startsWith("1.1") || v.startsWith("1.0");
    }

    private static boolean suppressSource(CompilerConfiguration config) {
        return JavacCompiler.isPreJava14(config);
    }

    private static boolean suppressEncoding(CompilerConfiguration config) {
        return JavacCompiler.isPreJava14(config);
    }

    protected CompilerResult compileOutOfProcess(CompilerConfiguration config, String executable, String[] args2) throws CompilerException {
        List<CompilerMessage> messages;
        int returnCode;
        CommandLineUtils.StringStreamConsumer err;
        CommandLineUtils.StringStreamConsumer out;
        Commandline cli;
        block12: {
            cli = new Commandline();
            cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
            cli.setExecutable(executable);
            try {
                File argumentsFile = this.createFileWithArguments(args2, config.getOutputLocation());
                cli.addArguments(new String[]{"@" + argumentsFile.getCanonicalPath().replace(File.separatorChar, '/')});
                if (!StringUtils.isEmpty(config.getMaxmem())) {
                    cli.addArguments(new String[]{"-J-Xmx" + config.getMaxmem()});
                }
                if (!StringUtils.isEmpty(config.getMeminitial())) {
                    cli.addArguments(new String[]{"-J-Xms" + config.getMeminitial()});
                }
                for (String key : config.getCustomCompilerArgumentsAsMap().keySet()) {
                    if (!StringUtils.isNotEmpty(key) || !key.startsWith("-J")) continue;
                    cli.addArguments(new String[]{key});
                }
            }
            catch (IOException e) {
                throw new CompilerException("Error creating file with javac arguments", e);
            }
            out = new CommandLineUtils.StringStreamConsumer();
            err = new CommandLineUtils.StringStreamConsumer();
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                File commandLineFile = new File(config.getOutputLocation(), "javac." + (Os.isFamily("windows") ? "bat" : "sh"));
                try {
                    FileUtils.fileWrite(commandLineFile.getAbsolutePath(), cli.toString().replaceAll("'", ""));
                    if (!Os.isFamily("windows")) {
                        Runtime.getRuntime().exec(new String[]{"chmod", "a+x", commandLineFile.getAbsolutePath()});
                    }
                }
                catch (IOException e) {
                    if (this.getLogger() == null || !this.getLogger().isWarnEnabled()) break block12;
                    this.getLogger().warn("Unable to write '" + commandLineFile.getName() + "' debug script file", e);
                }
            }
        }
        try {
            returnCode = CommandLineUtils.executeCommandLine(cli, out, err);
            messages = JavacCompiler.parseModernStream(returnCode, new BufferedReader(new StringReader(err.getOutput())));
        }
        catch (CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the external compiler.", e);
        }
        boolean success = returnCode == 0;
        return new CompilerResult(success, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompilerResult compileInProcess(String[] args2, CompilerConfiguration config) throws CompilerException {
        Class<?> javacClass = this.getJavacClass(config);
        Thread thread2 = Thread.currentThread();
        ClassLoader contextClassLoader = thread2.getContextClassLoader();
        thread2.setContextClassLoader(javacClass.getClassLoader());
        this.getLogger().debug("ttcl changed run compileInProcessWithProperClassloader");
        try {
            CompilerResult compilerResult = this.compileInProcessWithProperClassloader(javacClass, args2);
            return compilerResult;
        }
        finally {
            this.releaseJavaccClass(javacClass, config);
            thread2.setContextClassLoader(contextClassLoader);
        }
    }

    protected CompilerResult compileInProcessWithProperClassloader(Class<?> javacClass, String[] args2) throws CompilerException {
        return JavacCompiler.compileInProcess0(javacClass, args2);
    }

    private static CompilerResult compileInProcess0(Class<?> javacClass, String[] args2) throws CompilerException {
        List<CompilerMessage> messages;
        Integer ok;
        StringWriter out = new StringWriter();
        try {
            Method compile = javacClass.getMethod("compile", String[].class, PrintWriter.class);
            ok = (Integer)compile.invoke(null, args2, new PrintWriter(out));
            messages = JavacCompiler.parseModernStream(ok, new BufferedReader(new StringReader(out.toString())));
        }
        catch (NoSuchMethodException e) {
            throw new CompilerException("Error while executing the compiler.", e);
        }
        catch (IllegalAccessException e) {
            throw new CompilerException("Error while executing the compiler.", e);
        }
        catch (InvocationTargetException e) {
            throw new CompilerException("Error while executing the compiler.", e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the compiler.", e);
        }
        boolean success = ok == 0;
        return new CompilerResult(success, messages);
    }

    static List<CompilerMessage> parseModernStream(int exitCode, BufferedReader input) throws IOException {
        ArrayList<CompilerMessage> errors = new ArrayList<CompilerMessage>();
        while (true) {
            String line;
            StringBuilder buffer = new StringBuilder();
            do {
                if ((line = input.readLine()) == null) {
                    if (buffer.length() > 0 && buffer.toString().startsWith("javac:")) {
                        errors.add(new CompilerMessage(buffer.toString(), CompilerMessage.Kind.ERROR));
                    }
                    return errors;
                }
                if (buffer.length() == 0 && line.startsWith("error: ")) {
                    errors.add(new CompilerMessage(line, true));
                    continue;
                }
                if (buffer.length() == 0 && JavacCompiler.isNote(line)) continue;
                buffer.append(line);
                buffer.append(EOL);
            } while (!line.endsWith("^"));
            errors.add(JavacCompiler.parseModernError(exitCode, buffer.toString()));
        }
    }

    private static boolean isNote(String line) {
        for (int i = 0; i < NOTE_PREFIXES.length; ++i) {
            if (!line.startsWith(NOTE_PREFIXES[i])) continue;
            return true;
        }
        return false;
    }

    static CompilerMessage parseModernError(int exitCode, String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        boolean isError = exitCode != 0;
        try {
            int endcolumn;
            boolean tokenIsAnInteger;
            String file = null;
            String currentToken = null;
            do {
                if (currentToken != null) {
                    file = file == null ? currentToken : file + ':' + currentToken;
                }
                currentToken = tokens.nextToken();
                tokenIsAnInteger = true;
                try {
                    Integer.parseInt(currentToken);
                }
                catch (NumberFormatException e) {
                    tokenIsAnInteger = false;
                }
            } while (!tokenIsAnInteger);
            String lineIndicator = currentToken;
            int startOfFileName = file.lastIndexOf(93);
            if (startOfFileName > -1) {
                file = file.substring(startOfFileName + 1 + EOL.length());
            }
            int line = Integer.parseInt(lineIndicator);
            StringBuilder msgBuffer = new StringBuilder();
            String msg = tokens.nextToken(EOL).substring(2);
            String warnPrefix = JavacCompiler.getWarnPrefix(msg);
            if (warnPrefix != null) {
                isError = false;
                msg = msg.substring(warnPrefix.length());
            } else {
                isError = exitCode != 0;
            }
            msgBuffer.append(msg);
            msgBuffer.append(EOL);
            String context = tokens.nextToken(EOL);
            String pointer = tokens.nextToken(EOL);
            if (tokens.hasMoreTokens()) {
                msgBuffer.append(context);
                msgBuffer.append(EOL);
                msgBuffer.append(pointer);
                msgBuffer.append(EOL);
                context = tokens.nextToken(EOL);
                try {
                    pointer = tokens.nextToken(EOL);
                }
                catch (NoSuchElementException e) {
                    pointer = context;
                    context = null;
                }
            }
            String message = msgBuffer.toString();
            int startcolumn = pointer.indexOf("^");
            int n = endcolumn = context == null ? startcolumn : context.indexOf(" ", startcolumn);
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerMessage(file, isError, line, startcolumn, line, endcolumn, message.trim());
        }
        catch (NoSuchElementException e) {
            return new CompilerMessage("no more tokens - could not parse error message: " + error, isError);
        }
        catch (NumberFormatException e) {
            return new CompilerMessage("could not parse error message: " + error, isError);
        }
        catch (Exception e) {
            return new CompilerMessage("could not parse error message: " + error, isError);
        }
    }

    private static String getWarnPrefix(String msg) {
        for (int i = 0; i < WARNING_PREFIXES.length; ++i) {
            if (!msg.startsWith(WARNING_PREFIXES[i])) continue;
            return WARNING_PREFIXES[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String[] args2, String outputDirectory) throws IOException {
        PrintWriter writer = null;
        try {
            File tempFile;
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments", new File(outputDirectory));
            } else {
                tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments");
                tempFile.deleteOnExit();
            }
            writer = new PrintWriter(new FileWriter(tempFile));
            for (int i = 0; i < args2.length; ++i) {
                String argValue = args2[i].replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.println();
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static String getJavacExecutable() throws IOException {
        String javacCommand = "javac" + (Os.isFamily("windows") ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        File javacExe = Os.isName("AIX") ? new File(javaHome + File.separator + ".." + File.separator + "sh", javacCommand) : (Os.isName("Mac OS X") ? new File(javaHome + File.separator + "bin", javacCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javacCommand));
        if (!javacExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty(javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javacExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javacCommand);
        }
        if (!javacExe.isFile()) {
            throw new IOException("The javadoc executable '" + javacExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javacExe.getAbsolutePath();
    }

    private void releaseJavaccClass(Class<?> javaccClass, CompilerConfiguration compilerConfiguration) {
        if (compilerConfiguration.getCompilerReuseStrategy() == CompilerConfiguration.CompilerReuseStrategy.ReuseCreated) {
            this.javaccClasses.add(javaccClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getJavacClass(CompilerConfiguration compilerConfiguration) throws CompilerException {
        Class<?> c = null;
        switch (compilerConfiguration.getCompilerReuseStrategy()) {
            case AlwaysNew: {
                return this.createJavacClass();
            }
            case ReuseCreated: {
                List<Class<?>> list2 = this.javaccClasses;
                synchronized (list2) {
                    if (this.javaccClasses.size() > 0) {
                        c = this.javaccClasses.get(0);
                        this.javaccClasses.remove(c);
                        return c;
                    }
                }
                c = this.createJavacClass();
                return c;
            }
        }
        c = JAVAC_CLASS;
        if (c != null) {
            return c;
        }
        Object object = LOCK;
        synchronized (object) {
            if (c == null) {
                JAVAC_CLASS = c = this.createJavacClass();
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> createJavacClass() throws CompilerException {
        try {
            return JavacCompiler.class.getClassLoader().loadClass(JAVAC_CLASSNAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
            if (!toolsJar.exists()) {
                throw new CompilerException("tools.jar not found: " + toolsJar);
            }
            URL[] originalUrls = ((URLClassLoader)JavacCompiler.class.getClassLoader()).getURLs();
            URL[] urls = new URL[originalUrls.length + 1];
            urls[0] = toolsJar.toURI().toURL();
            System.arraycopy(originalUrls, 0, urls, 1, originalUrls.length);
            URLClassLoader javacClassLoader = new URLClassLoader(urls);
            Thread thread2 = Thread.currentThread();
            ClassLoader contextClassLoader = thread2.getContextClassLoader();
            thread2.setContextClassLoader(javacClassLoader);
            try {
                Class<?> clazz = javacClassLoader.loadClass(JAVAC_CLASSNAME);
                thread2.setContextClassLoader(contextClassLoader);
                return clazz;
            }
            catch (Throwable throwable) {
                try {
                    thread2.setContextClassLoader(contextClassLoader);
                    throw throwable;
                }
                catch (MalformedURLException ex) {
                    throw new CompilerException("Could not convert the file reference to tools.jar to a URL, path to tools.jar: '" + toolsJar.getAbsolutePath() + "'.", ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new CompilerException("Unable to locate the Javac Compiler in:" + EOL + "  " + toolsJar + EOL + "Please ensure you are using JDK 1.4 or above and" + EOL + "not a JRE (the com.sun.tools.javac.Main class is required)." + EOL + "In most cases you can change the location of your Java" + EOL + "installation by setting the JAVA_HOME environment variable.", ex);
                }
            }
        }
    }
}

