/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.os;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.os.ProcessBasedExecution;
import org.arquillian.spacelift.task.os.ProcessReference;
import org.arquillian.spacelift.task.os.Validate;

class SpawnProcessTask
extends Task<Object, Process> {
    private Command command;
    private boolean redirectErrorStream;
    private List<Integer> allowedExitCodes;
    private File workingDirectory;
    private Map<String, String> environment;
    private boolean runsAsDaemon;

    SpawnProcessTask() {
    }

    public SpawnProcessTask redirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        this.environment = new HashMap<String, String>();
        return this;
    }

    public SpawnProcessTask command(Command command2) {
        this.command = command2;
        return this;
    }

    public SpawnProcessTask workingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public SpawnProcessTask addEnvironment(Map<String, String> environment) {
        this.environment.putAll(environment);
        return this;
    }

    public SpawnProcessTask shouldExitWith(List<Integer> allowedExitCodes) {
        this.allowedExitCodes = allowedExitCodes;
        return this;
    }

    public SpawnProcessTask runAsDaemon(boolean isDaemon) {
        this.runsAsDaemon = isDaemon;
        return this;
    }

    @Override
    public Execution<Process> execute() throws ExecutionException {
        Execution processFutureExecution = super.execute();
        Process process = (Process)processFutureExecution.await();
        ProcessReference ref = new ProcessReference(this.command.getProgramName());
        ref.setProcess(process);
        ProcessBasedExecution<Process> execution = new ProcessBasedExecution<Process>(processFutureExecution, ref, this.command.getProgramName(), this.allowedExitCodes);
        if (!this.runsAsDaemon) {
            execution.registerShutdownHook();
        }
        return execution;
    }

    @Override
    protected Process process(Object input) throws Exception {
        Validate.executionNotNull(this.command, "Command must not be null", new Object[0]);
        Validate.executionNotNull(this.command.getProgramName(), "Command program name must not be null", new Object[0]);
        ProcessBuilder builder = new ProcessBuilder(this.command.getFullCommand());
        builder.directory(this.workingDirectory);
        builder.environment().putAll(this.environment);
        builder.redirectErrorStream(this.redirectErrorStream);
        return builder.start();
    }
}

