/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.os;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.process.OutputTransformer;
import org.arquillian.spacelift.process.ProcessInteraction;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.process.Sentence;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.os.ProcessResultImpl;
import org.arquillian.spacelift.task.os.SentenceImpl;

class ConsumeProcessOutputTask
extends Task<Execution<Process>, ProcessResult> {
    private static final Logger log = Logger.getLogger(ConsumeProcessOutputTask.class.getName());
    private ProcessInteraction interactionDefinition;
    private String programName;

    ConsumeProcessOutputTask() {
    }

    public ConsumeProcessOutputTask programName(String programName) {
        this.programName = programName;
        return this;
    }

    public ConsumeProcessOutputTask interaction(ProcessInteraction interaction) {
        this.interactionDefinition = interaction;
        return this;
    }

    @Override
    protected ProcessResult process(Execution<Process> runningProcess) throws Exception {
        Process process = runningProcess.await();
        ArrayList<String> output = new ArrayList<String>();
        ProcessResultImpl result2 = new ProcessResultImpl(process, this.programName, output);
        ProcessInteractionApplicator interaction = new ProcessInteractionApplicator(this.interactionDefinition, this.programName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedOutputStream writer = new BufferedOutputStream(process.getOutputStream());
        if (!interaction.requiresInputInteraction()) {
            try {
                ((OutputStream)writer).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            int i;
            boolean reachedEOF = false;
            if (interaction.typesInitialText() != null) {
                ((OutputStream)writer).flush();
                ((OutputStream)writer).write(interaction.typesInitialText().getBytes());
                ((OutputStream)writer).flush();
                output.add(interaction.typesInitialText());
            }
            SentenceImpl sentence = new SentenceImpl();
            while (!reachedEOF && (i = reader.read()) != -1) {
                sentence.append((char)i);
                boolean shouldTerminate = interaction.shouldTerminate(sentence);
                String answer = interaction.repliesTo(sentence);
                if (answer != null) {
                    sentence.append(answer);
                    ((OutputStream)writer).flush();
                    ((OutputStream)writer).write(answer.getBytes());
                    ((OutputStream)writer).flush();
                }
                if (shouldTerminate) {
                    runningProcess.markAsFinished();
                    runningProcess.terminate();
                }
                reachedEOF = runningProcess.isMarkedAsFinished();
                if (!sentence.isFinished()) continue;
                sentence.trim();
                log.log(Level.FINEST, "({0}): {1}", new Object[]{result2.processName(), sentence});
                output.add(((Object)sentence).toString());
                if (interaction.shouldOutput(sentence)) {
                    System.out.println(interaction.transform(sentence));
                }
                if (interaction.shouldOutputToErr(sentence)) {
                    System.err.println(interaction.transform(sentence));
                }
                sentence.reset();
            }
            if (!sentence.isEmpty()) {
                log.log(Level.FINEST, "{0} outputs: {1}", new Object[]{result2.processName(), sentence});
                output.add(((Object)sentence).toString());
                if (interaction.shouldOutput(sentence)) {
                    System.out.println(interaction.transform(sentence));
                }
                if (interaction.shouldOutputToErr(sentence)) {
                    System.err.println(interaction.transform(sentence));
                }
            }
        }
        catch (IOException i) {
            // empty catch block
        }
        try {
            if (writer != null) {
                ((OutputStream)writer).close();
            }
        }
        catch (IOException i) {
            // empty catch block
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e.getCause() != null ? e.getCause() : e, "Execution of \"{0}\" was interrupted with: {1}", this.programName, e.getMessage());
        }
        finally {
            if (process != null) {
                InputStream in = process.getInputStream();
                InputStream err = process.getErrorStream();
                OutputStream out = process.getOutputStream();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (IOException iOException) {}
                }
                process.destroy();
            }
        }
        return result2;
    }

    private static class ProcessInteractionApplicator {
        final ProcessInteraction interaction;
        final OutputTransformer transformer;

        public ProcessInteractionApplicator(ProcessInteraction interaction, final String processName) {
            this.interaction = interaction;
            this.transformer = interaction.transformer() == null ? new OutputTransformer(){

                @Override
                public Sentence transform(Sentence output) {
                    return output.prepend("):").prepend(processName).prepend("(");
                }
            } : interaction.transformer();
        }

        public String typesInitialText() {
            return this.interaction.textTypedIn();
        }

        public String repliesTo(Sentence sentence) {
            for (Map.Entry<Pattern, String> entry2 : this.interaction.replyMap().entrySet()) {
                if (!entry2.getKey().matcher(sentence).matches()) continue;
                return entry2.getValue();
            }
            return null;
        }

        public boolean shouldTerminate(Sentence sentence) {
            for (Pattern p : this.interaction.terminatingOutput()) {
                if (!p.matcher(sentence).matches()) continue;
                return true;
            }
            return false;
        }

        public boolean shouldOutput(Sentence sentence) {
            for (Pattern p : this.interaction.allowedOutput()) {
                if (!p.matcher(sentence).matches()) continue;
                return true;
            }
            return false;
        }

        public Sentence transform(Sentence original) {
            return this.transformer.transform(original);
        }

        public boolean shouldOutputToErr(Sentence sentence) {
            for (Pattern p : this.interaction.errorOutput()) {
                if (!p.matcher(sentence).matches()) continue;
                return true;
            }
            return false;
        }

        public boolean requiresInputInteraction() {
            return !this.interaction.replyMap().isEmpty() || this.interaction.textTypedIn() != null && this.interaction.textTypedIn() != "";
        }
    }
}

