/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.net;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.task.Task;

public class DownloadTool
extends Task<Object, File> {
    private URL url;
    private File output;
    private int timeout = 5000;
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean followRedirects = true;

    public DownloadTool from(String url2) throws IllegalArgumentException {
        try {
            return this.from(new URL(url2));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public DownloadTool from(URL url2) {
        this.url = url2;
        return this;
    }

    public DownloadTool to(String filePath) {
        return this.to(new File(filePath));
    }

    public DownloadTool to(File file) {
        this.output = file;
        return this;
    }

    public DownloadTool timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public DownloadTool property(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public DownloadTool followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    protected File process(Object input) throws Exception {
        if (this.url == null) {
            throw new IllegalStateException("Source URL was not set");
        }
        if (this.output == null) {
            throw new IllegalStateException("Destination file was not set");
        }
        this.tryDownload(this.url);
        return this.output;
    }

    private void tryDownload(URL url2) {
        this.tryDownload(url2, new ArrayList<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDownload(URL url2, List<String> redirectUrls) {
        String urlExternalForm = url2.toExternalForm();
        if (redirectUrls.contains(urlExternalForm)) {
            throw new IllegalStateException("The site contains an infinite redirect loop! Duplicate url: " + urlExternalForm);
        }
        redirectUrls.add(urlExternalForm);
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            try {
                int read;
                HttpURLConnection httpConnection;
                int responseCode;
                URLConnection connection = url2.openConnection();
                connection.setReadTimeout(this.timeout);
                for (Map.Entry<String, String> property : this.properties.entrySet()) {
                    connection.setRequestProperty(property.getKey(), property.getValue());
                }
                if (connection instanceof HttpURLConnection && (responseCode = (httpConnection = (HttpURLConnection)connection).getResponseCode()) > 300 && responseCode < 400 && this.followRedirects) {
                    String redirectLocation = connection.getHeaderField("Location");
                    if (redirectLocation == null || redirectLocation.equals("")) {
                        throw new IllegalStateException("The site response code was a redirect one (" + responseCode + ") but no 'Location' header was sent.");
                    }
                    this.tryDownload(new URL(redirectLocation));
                    return;
                }
                is = connection.getInputStream();
                fos = new FileOutputStream(this.output);
                byte[] buffer = new byte[4096];
                while ((read = is.read(buffer)) != -1) {
                    fos.write(buffer, 0, read);
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ExecutionException(e, "Unable to download from {0} to {1}", url2, this.output);
        }
    }
}

