/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.util.CharsetUtil;

public class FileWriter
extends Task<Map<File, String>, List<File>> {
    private Charset charset = CharsetUtil.getUtf8OrDefault();

    public FileWriter charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<File> process(Map<File, String> input) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : input.keySet()) {
            String content = input.get(file);
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(file);
                byte[] contentBytes = content.getBytes(this.charset);
                ((OutputStream)outputStream).write(contentBytes, 0, contentBytes.length);
                outputStream.flush();
                files.add(file);
            }
            finally {
                if (outputStream == null) continue;
                ((OutputStream)outputStream).close();
            }
        }
        return files;
    }
}

