/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.arquillian.spacelift.task.InvalidTaskException;
import org.arquillian.spacelift.task.NoArgConstructorTaskFactory;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.TaskFactory;
import org.arquillian.spacelift.task.TaskRegistry;

public class TaskRegistryImpl
implements TaskRegistry {
    private final Map<Class<?>, TaskFactory<?, ?, ?>> classRegistry = new ConcurrentHashMap();
    private final Map<String, TaskFactory<?, ?, ?>> aliasRegistry = new ConcurrentHashMap();

    @Override
    public <IN, OUT, TASK extends Task<? super IN, OUT>, TASK_FACTORY extends TaskFactory<IN, OUT, TASK>> TaskRegistry register(Class<TASK> taskDef, TASK_FACTORY taskFactory) throws InvalidTaskException {
        for (String alias : taskFactory.aliases()) {
            this.aliasRegistry.put(alias, taskFactory);
        }
        if (taskDef != null) {
            this.classRegistry.put(taskDef, taskFactory);
            this.aliasRegistry.put(taskDef.getName(), taskFactory);
            this.aliasRegistry.put(taskDef.getSimpleName(), taskFactory);
        }
        return this;
    }

    @Override
    public <IN, OUT, TASK extends Task<? super IN, OUT>, TASK_FACTORY extends TaskFactory<IN, OUT, TASK>> TaskRegistry register(TASK_FACTORY taskFactory) throws InvalidTaskException {
        return this.register(null, taskFactory);
    }

    @Override
    public <IN, OUT, TASK extends Task<? super IN, OUT>> TaskRegistry register(Class<TASK> taskType, String ... aliases) throws InvalidTaskException {
        return this.register(taskType, new NoArgConstructorTaskFactory(taskType, aliases));
    }

    @Override
    public <IN, OUT, TASK extends Task<? super IN, OUT>> TASK find(Class<TASK> taskType) throws InvalidTaskException {
        if (!this.classRegistry.containsKey(taskType)) {
            this.register(taskType, new NoArgConstructorTaskFactory(taskType, new String[0]));
        }
        return (TASK)this.classRegistry.get(taskType).create();
    }

    @Override
    public Task<?, ?> find(String alias) throws InvalidTaskException {
        if (!this.aliasRegistry.containsKey(alias)) {
            throw new InvalidTaskException("No task with alias {0} was registered.", alias);
        }
        return this.aliasRegistry.get(alias).create();
    }

    @Override
    public <IN, OUT> Task<IN, OUT> find(String alias, Class<IN> inType, Class<OUT> outType) throws InvalidTaskException {
        if (!this.aliasRegistry.containsKey(alias)) {
            throw new InvalidTaskException("No task with alias {0} was registered.", alias);
        }
        return this.aliasRegistry.get(alias).create();
    }
}

