/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.archive;

import java.io.BufferedInputStream;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.task.archive.UncompressTool;

public class UnzipTool
extends UncompressTool {
    @Override
    protected ArchiveInputStream compressedInputStream(InputStream compressedFile) {
        BufferedInputStream in = new BufferedInputStream(compressedFile);
        return new ZipArchiveInputStream(in);
    }

    @Override
    protected int permissionsMode(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof ZipArchiveEntry) {
            ZipExtraField[] extraFields;
            ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)archiveEntry;
            for (ZipExtraField zipExtraField : extraFields = zipArchiveEntry.getExtraFields()) {
                if (!(zipExtraField instanceof AsiExtraField)) continue;
                AsiExtraField asiExtraField = (AsiExtraField)zipExtraField;
                return asiExtraField.getMode();
            }
        } else {
            throw new ExecutionException("No ZipEntry has been passed to a Unzip method.", new Object[0]);
        }
        return 0;
    }
}

