/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.archive;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.archive.FilePermission;
import org.arquillian.spacelift.task.archive.PermissionsUtil;
import org.arquillian.spacelift.task.text.ReplacementTuple;

public abstract class UncompressTool
extends Task<File, File> {
    protected static final String CUT_DIR_PATTERN = "^/?([^/]+)/(.*)";
    protected static final String CUT_DIR_REPLACEMENT = "$2";
    private static final int BUFFER = 2048;
    private List<ReplacementTuple<?>> replacements = new ArrayList();
    private File dest;

    protected abstract ArchiveInputStream compressedInputStream(InputStream var1);

    protected abstract int permissionsMode(ArchiveEntry var1);

    public UncompressTool toDir(String pathToDestination) {
        return this.toDir(new File(pathToDestination));
    }

    public UncompressTool toDir(File destination) {
        this.dest = destination;
        return this;
    }

    public ReplacementTuple<UncompressTool> remap(String pattern) {
        ReplacementTuple<UncompressTool> replacement = new ReplacementTuple<UncompressTool>(this, pattern);
        this.replacements.add(replacement);
        return replacement;
    }

    public UncompressTool cutdirs() {
        ReplacementTuple<UncompressTool> replacement = new ReplacementTuple<UncompressTool>(this, CUT_DIR_PATTERN);
        replacement.with(CUT_DIR_REPLACEMENT);
        this.replacements.add(replacement);
        return this;
    }

    @Override
    protected File process(File input) throws Exception {
        ArchiveEntry entry2 = null;
        ArchiveInputStream compressedInputStream = this.compressedInputStream(new FileInputStream(input));
        while ((entry2 = compressedInputStream.getNextEntry()) != null) {
            int count2;
            File file = new File(this.dest, this.remapEntryName(entry2.getName()));
            if (entry2.isDirectory()) {
                file.mkdirs();
                continue;
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            byte[] data2 = new byte[2048];
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
            while ((count2 = compressedInputStream.read(data2, 0, 2048)) != -1) {
                dest.write(data2, 0, count2);
            }
            dest.close();
            int permissionsMode = this.permissionsMode(entry2);
            if (permissionsMode == 0) continue;
            FilePermission filePermission = PermissionsUtil.toFilePermission(permissionsMode);
            PermissionsUtil.applyPermission(file, filePermission);
        }
        compressedInputStream.close();
        return this.dest;
    }

    private String remapEntryName(String entryName) {
        if (entryName == null) {
            return entryName;
        }
        String finalName = entryName.replaceAll("\\\\", "/");
        for (ReplacementTuple<?> remap : this.replacements) {
            finalName = finalName.replaceAll(remap.getRegex(), remap.getReplacement());
        }
        return finalName;
    }
}

