/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static <T> T newInstance(Class<T> clazz) throws IllegalArgumentException, IllegalStateException, RuntimeException {
        return SecurityActions.newInstance(clazz, new Class[0], new Object[0], clazz);
    }

    private static <T> T newInstance(Class<?> clazz, Class<?>[] argumentTypes, Object[] arguments2, Class<T> expectedType) throws IllegalArgumentException, IllegalStateException, RuntimeException {
        Object obj;
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty ar>ray if no arguments");
        }
        try {
            Constructor<?> constructor = SecurityActions.getConstructor(clazz, argumentTypes);
            constructor.setAccessible(true);
            obj = constructor.newInstance(arguments2);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to find a constructor for implementation class " + SecurityActions.getConstructorName(clazz.getName(), argumentTypes));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unable to instantiate a " + clazz.getName(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to instantiate a " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to instantiate a " + clazz.getName() + " instance, access refused by SecurityManager.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(String.format("Unable to instantiate task via %s: %s", SecurityActions.getConstructorName(clazz.getName(), argumentTypes), e.getCause()), e.getCause());
        }
        try {
            return expectedType.cast(obj);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Unable to instantiate " + expectedType.getName() + " instance. Constructed object was type of " + obj.getClass().getName() + ", which is not compatible.");
        }
    }

    private static Constructor<?> getConstructor(final Class<?> clazz, final Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws NoSuchMethodException {
                    return clazz.getDeclaredConstructor(argumentTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t2 = pae.getCause();
            if (t2 instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t2;
            }
            try {
                throw (RuntimeException)t2;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t2);
            }
        }
    }

    private static String getConstructorName(String className, Class<?>[] argumentTypes) {
        StringBuilder constructor = new StringBuilder(className).append("(");
        for (Class<?> arg : argumentTypes) {
            constructor.append(arg.getSimpleName()).append(",");
        }
        if (constructor.charAt(constructor.length() - 1) == ',') {
            constructor.deleteCharAt(constructor.length() - 1);
        }
        constructor.append(")");
        return constructor.toString();
    }

    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

