/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.loader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.spacelift.loader.SecurityActions;
import org.arquillian.spacelift.loader.ServiceLoader;

public class SpiServiceLoader
implements ServiceLoader {
    private static final Logger log = Logger.getLogger(SpiServiceLoader.class.getName());
    private static final String SERVICES = "META-INF/services";
    private ClassLoader classLoader;

    public SpiServiceLoader() {
        this.classLoader = SpiServiceLoader.class.getClassLoader();
    }

    public SpiServiceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public <T> Collection<T> all(Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("ServiceClass must be provided");
        }
        return this.createInstances(serviceClass, this.load(serviceClass));
    }

    @Override
    public <T> T onlyOne(Class<T> serviceClass) {
        Collection<T> services = this.all(serviceClass);
        if (services.isEmpty()) {
            throw new IllegalStateException("There are no services for serviceClass " + serviceClass.getName());
        }
        if (services.size() > 1) {
            throw new IllegalStateException("There are more than 1 services for serviceClass " + serviceClass.getName());
        }
        return services.iterator().next();
    }

    @Override
    public <T> T onlyOne(Class<T> serviceClass, Class<? extends T> defaultImplementationClass) {
        if (defaultImplementationClass == null) {
            throw new IllegalArgumentException("DefaultImplementationClass must be provided");
        }
        Collection<T> services = this.all(serviceClass);
        if (services.size() == 0) {
            return this.createInstance(defaultImplementationClass);
        }
        if (services.size() == 1) {
            return services.iterator().next();
        }
        if (services.size() == 2) {
            for (T service : services) {
                if (defaultImplementationClass.equals(service.getClass())) continue;
                return service;
            }
        }
        throw new IllegalStateException("There is more then a one service for serviceClass " + serviceClass.getName());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<Class<? extends T>> load(Class<T> serviceClass) {
        String serviceFile = "META-INF/services/" + serviceClass.getName();
        LinkedHashSet<Class<T>> providers = new LinkedHashSet<Class<T>>();
        try {
            Enumeration<URL> enumeration = this.classLoader.getResources(serviceFile);
            while (enumeration.hasMoreElements()) {
                URL url2 = enumeration.nextElement();
                InputStream is = url2.openStream();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = reader.readLine();
                    while (null != line) {
                        if ((line = this.skipCommentAndTrim(line)).length() > 0) {
                            try {
                                Class<T> provider = this.classLoader.loadClass(line).asSubclass(serviceClass);
                                providers.add(provider);
                            }
                            catch (ClassCastException e) {
                                ClassLoader other = serviceClass.getClassLoader();
                                if (!this.classLoader.getClass().equals(serviceClass.getClassLoader())) {
                                    throw new IllegalStateException("Service " + line + " was loaded by different classloader (" + (other == null ? "bootstrap" : other.getClass().getName()) + ") then service interface " + serviceClass.getName() + " (" + this.classLoader.getClass().getName() + "), unable to cast classes");
                                }
                                throw new IllegalStateException("Service " + line + " does not implement expected type " + serviceClass.getName());
                            }
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load services for " + serviceClass.getName(), e);
        }
        return providers;
    }

    private String skipCommentAndTrim(String line) {
        int comment = line.indexOf(35);
        if (comment > -1) {
            line = line.substring(0, comment);
        }
        line = line.trim();
        return line;
    }

    private <T> Set<T> createInstances(Class<T> serviceType, Set<Class<? extends T>> providers) {
        LinkedHashSet<T> providerImpls = new LinkedHashSet<T>();
        for (Class<T> serviceClass : providers) {
            if (serviceClass.isEnum()) {
                T[] enumInstances;
                for (T enumInstance : enumInstances = serviceClass.getEnumConstants()) {
                    providerImpls.add(enumInstance);
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "Registered new service for type {0}: {1}#{2}", new Object[]{serviceType.getName(), serviceClass.getName(), enumInstance.toString()});
                }
                continue;
            }
            providerImpls.add(this.createInstance(serviceClass));
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Registered new service for type {0}: {1}", new Object[]{serviceType.getName(), serviceClass.getName()});
        }
        return providerImpls;
    }

    private <T> T createInstance(Class<T> implClass) {
        T instance;
        Constructor<T> ctor;
        try {
            ctor = SecurityActions.getConstructor(implClass, new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(implClass + " must contain a public no args contructor");
        }
        try {
            instance = ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new service instance", e);
        }
        return implClass.cast(instance);
    }
}

