/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.loader;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.spacelift.loader.ServiceLoader;

public class ServiceRegistry
implements ServiceLoader {
    private static ServiceRegistry instance;
    private ServiceLoader serviceLoader;
    private Map<Class<?>, Collection<?>> cachedServiceInstances;

    public ServiceRegistry(ServiceLoader serviceLoader) {
        this.serviceLoader = serviceLoader;
        this.cachedServiceInstances = Collections.synchronizedMap(new HashMap());
    }

    public static synchronized ServiceRegistry getInstance() throws IllegalStateException {
        if (instance == null) {
            throw new IllegalStateException("Unable to get instance of Service Registry, it was not initialized.");
        }
        return instance;
    }

    public static synchronized void register(ServiceRegistry registry) {
        instance = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Collection<T> all(Class<T> serviceClass) throws IllegalArgumentException {
        if (serviceClass == null) {
            throw new IllegalArgumentException("ServiceClass must be provided");
        }
        Map<Class<?>, Collection<?>> map2 = this.cachedServiceInstances;
        synchronized (map2) {
            if (this.cachedServiceInstances.containsKey(serviceClass)) {
                return this.cachedServiceInstances.get(serviceClass);
            }
            Collection<T> services = this.serviceLoader.all(serviceClass);
            this.cachedServiceInstances.put(serviceClass, services);
            return services;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T onlyOne(Class<T> serviceClass) throws IllegalArgumentException, IllegalStateException {
        if (serviceClass == null) {
            throw new IllegalArgumentException("ServiceClass must be provided");
        }
        Map<Class<?>, Collection<?>> map2 = this.cachedServiceInstances;
        synchronized (map2) {
            if (this.cachedServiceInstances.containsKey(serviceClass)) {
                return (T)this.cachedServiceInstances.get(serviceClass).iterator().next();
            }
            T service = this.serviceLoader.onlyOne(serviceClass);
            this.cachedServiceInstances.put(serviceClass, Collections.singleton(service));
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T onlyOne(Class<T> serviceClass, Class<? extends T> defaultImplementationClass) throws IllegalArgumentException, IllegalStateException {
        if (serviceClass == null) {
            throw new IllegalArgumentException("ServiceClass must be provided");
        }
        Map<Class<?>, Collection<?>> map2 = this.cachedServiceInstances;
        synchronized (map2) {
            if (this.cachedServiceInstances.containsKey(serviceClass)) {
                return (T)this.cachedServiceInstances.get(serviceClass).iterator().next();
            }
            T service = this.serviceLoader.onlyOne(serviceClass, defaultImplementationClass);
            this.cachedServiceInstances.put(serviceClass, Collections.singleton(service));
            return service;
        }
    }
}

