/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.execution.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.arquillian.spacelift.execution.CountDownWatch;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionCondition;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.execution.ExecutionService;
import org.arquillian.spacelift.execution.TimeoutExecutionException;
import org.arquillian.spacelift.execution.impl.ShutdownHooks;

class FutureBasedExecution<RESULT>
implements Execution<RESULT> {
    public static final long DEFAULT_POLL_INTERVAL = 500L;
    public static final TimeUnit DEFAULT_POLL_TIME_UNIT = TimeUnit.MILLISECONDS;
    private final Callable<RESULT> executionTask;
    private final Future<RESULT> executionFuture;
    private final ExecutionService service;
    private long pollInterval;
    private TimeUnit pollUnit;
    private boolean shouldBeFinished;

    public FutureBasedExecution(ExecutionService service, Callable<RESULT> task, Future<RESULT> future) {
        this.service = service;
        this.executionTask = task;
        this.executionFuture = future;
        this.pollInterval = 500L;
        this.pollUnit = DEFAULT_POLL_TIME_UNIT;
    }

    private static ExecutionException unwrapException(Throwable cause, String messageFormat, Object ... parameters2) {
        ExecutionException deepestCause = null;
        for (Throwable current = cause; current != null; current = current.getCause()) {
            if (!(current instanceof ExecutionException)) continue;
            deepestCause = (ExecutionException)current;
        }
        if (deepestCause != null) {
            return deepestCause.prependMessage(messageFormat, parameters2);
        }
        return new ExecutionException(cause, messageFormat, parameters2);
    }

    private static TimeoutExecutionException unwrapExceptionAsTimeoutException(Throwable cause, String messageFormat, Object ... parameters2) {
        for (Throwable current = cause; current != null; current = current.getCause()) {
            if (!(current instanceof ExecutionException)) continue;
            return new TimeoutExecutionException(current, messageFormat, parameters2);
        }
        return new TimeoutExecutionException(cause, messageFormat, parameters2);
    }

    @Override
    public Execution<RESULT> markAsFinished() {
        this.shouldBeFinished = true;
        return this;
    }

    @Override
    public Execution<RESULT> registerShutdownHook() {
        ShutdownHooks.addHookFor(this);
        return this;
    }

    @Override
    public boolean isMarkedAsFinished() {
        return this.shouldBeFinished;
    }

    @Override
    public boolean isFinished() {
        return this.isMarkedAsFinished() || this.executionFuture.isDone();
    }

    @Override
    public boolean hasFailed() {
        return this.executionFuture.isCancelled();
    }

    @Override
    public Execution<RESULT> terminate() {
        this.executionFuture.cancel(true);
        return this;
    }

    @Override
    public RESULT await() throws ExecutionException {
        try {
            return this.executionFuture.get();
        }
        catch (InterruptedException e) {
            throw FutureBasedExecution.unwrapException(e, "Interrupted while executing a task", new Object[0]);
        }
        catch (java.util.concurrent.ExecutionException e) {
            throw FutureBasedExecution.unwrapException(e, "Execution of a task failed", new Object[0]);
        }
    }

    @Override
    public RESULT awaitAtMost(long timeout, TimeUnit unit) {
        try {
            return this.executionFuture.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw FutureBasedExecution.unwrapException(e, "Interrupted while executing a task", new Object[0]);
        }
        catch (java.util.concurrent.ExecutionException e) {
            throw FutureBasedExecution.unwrapException(e, "Execution of a task failed", new Object[0]);
        }
        catch (TimeoutException e) {
            throw FutureBasedExecution.unwrapExceptionAsTimeoutException(e, "Timed out after {0}{1} while executing a task", new Object[]{timeout, unit});
        }
    }

    @Override
    public Execution<RESULT> reexecuteEvery(long step, TimeUnit unit) {
        this.pollInterval = step;
        this.pollUnit = unit;
        return this;
    }

    @Override
    public RESULT until(long timeout, TimeUnit unit, ExecutionCondition<RESULT> condition) throws ExecutionException, TimeoutExecutionException {
        CountDownWatch countdown = new CountDownWatch(timeout, unit);
        Execution<RESULT> currentExecution = new FutureBasedExecution<RESULT>(this.service, this.executionTask, this.executionFuture);
        while (countdown.timeLeft() > 0L) {
            try {
                Object result2 = currentExecution.awaitAtMost(countdown.timeLeft(), countdown.getTimeUnit());
                Execution<RESULT> nextExecution = this.service.schedule(this.executionTask, this.pollInterval, this.pollUnit);
                if (condition.satisfiedBy(result2)) {
                    try {
                        nextExecution.terminate();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                    return result2;
                }
                currentExecution = nextExecution;
            }
            catch (TimeoutExecutionException e) {}
        }
        throw new TimeoutExecutionException("Unable to trigger condition within {0} {1}.", timeout, unit.toString().toLowerCase());
    }

    @Override
    public RESULT awaitAtMost(CountDownWatch timeout) throws ExecutionException, TimeoutExecutionException {
        return this.awaitAtMost(timeout.timeout(), timeout.getTimeUnit());
    }

    @Override
    public RESULT until(CountDownWatch timeout, ExecutionCondition<RESULT> condition) throws ExecutionException, TimeoutExecutionException {
        return this.until(timeout.timeout(), timeout.getTimeUnit(), condition);
    }
}

