/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.execution.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.execution.ExecutionService;
import org.arquillian.spacelift.execution.TimeoutExecutionException;
import org.arquillian.spacelift.execution.impl.FutureBasedExecution;
import org.arquillian.spacelift.execution.impl.SpaceliftThreadFactory;

public class ExecutionServiceImpl
implements ExecutionService {
    private final ExecutorService service;
    private final ScheduledExecutorService scheduledService;

    public ExecutionServiceImpl() {
        SpaceliftThreadFactory threadFactory = new SpaceliftThreadFactory();
        this.service = Executors.newCachedThreadPool(threadFactory);
        this.scheduledService = Executors.newScheduledThreadPool(1, threadFactory);
    }

    @Override
    public <T> Execution<T> execute(Callable<T> task) throws ExecutionException {
        Future<T> future = this.service.submit(task);
        return new FutureBasedExecution<T>(this, task, future);
    }

    @Override
    public <T> Execution<T> schedule(Callable<T> task, long delay, TimeUnit unit) throws TimeoutExecutionException, ExecutionException {
        ScheduledFuture<T> future = this.scheduledService.schedule(task, delay, unit);
        return new FutureBasedExecution<T>(this, task, future);
    }
}

