/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.repository;

import java.io.Serializable;
import java.util.Properties;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.codehaus.plexus.util.StringUtils;

public class Repository
implements Serializable {
    private static final long serialVersionUID = 1312227676322136247L;
    private String id;
    private String name;
    private String host;
    private int port = -1;
    private String basedir;
    private String protocol;
    private String url;
    private RepositoryPermissions permissions;
    private Properties parameters = new Properties();
    private String username = null;
    private String password = null;

    public Repository() {
    }

    public Repository(String id2, String url2) {
        if (id2 == null) {
            throw new NullPointerException("id cannot be null");
        }
        this.setId(id2);
        if (url2 == null) {
            throw new NullPointerException("url cannot be null");
        }
        this.setUrl(url2);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUrl(String url2) {
        String username;
        this.url = url2;
        this.protocol = PathUtils.protocol(url2);
        this.host = PathUtils.host(url2);
        this.port = PathUtils.port(url2);
        this.basedir = PathUtils.basedir(url2);
        this.username = username = PathUtils.user(url2);
        if (username != null) {
            String password = PathUtils.password(url2);
            if (password != null) {
                this.password = password;
                username = username + ":" + password;
            }
            username = username + "@";
            int index = url2.indexOf(username);
            this.url = url2.substring(0, index) + url2.substring(index + username.length());
        }
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.protocol);
        sb.append("://");
        if (this.isIPv6Address()) {
            sb.append("[").append(this.getHost()).append("]");
        } else {
            sb.append(this.getHost());
        }
        if (this.port != -1) {
            sb.append(":");
            sb.append(this.port);
        }
        sb.append(this.basedir);
        return sb.toString();
    }

    private boolean isIPv6Address() {
        return this.getHost().contains(":");
    }

    public String getHost() {
        if (this.host == null) {
            return "localhost";
        }
        return this.host;
    }

    public String getName() {
        if (this.name == null) {
            return this.getId();
        }
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Repository[");
        if (StringUtils.isNotEmpty(this.getName())) {
            sb.append(this.getName()).append("|");
        }
        sb.append(this.getUrl());
        sb.append("]");
        return sb.toString();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public RepositoryPermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(RepositoryPermissions permissions) {
        this.permissions = permissions;
    }

    public String getParameter(String key) {
        return this.parameters.getProperty(key);
    }

    public void setParameters(Properties parameters2) {
        this.parameters = parameters2;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.id == null ? 0 : this.id.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Repository other = (Repository)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

