/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.maven.wagon.providers.http.LightweightHttpWagon;

public class LightweightHttpWagonAuthenticator
extends Authenticator {
    ThreadLocal<LightweightHttpWagon> localWagon = new ThreadLocal();

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        LightweightHttpWagon wagon = this.localWagon.get();
        if (wagon != null) {
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                return wagon.requestProxyAuthentication();
            }
            return wagon.requestServerAuthentication();
        }
        return null;
    }

    public void setWagon(LightweightHttpWagon wagon) {
        this.localWagon.set(wagon);
        Authenticator.setDefault(this);
    }

    public void resetWagon() {
        this.localWagon.remove();
    }
}

