/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.DatagramOutputStream;
import org.apache.logging.log4j.util.Strings;

public class DatagramSocketManager
extends AbstractSocketManager {
    private static final DatagramSocketManagerFactory FACTORY = new DatagramSocketManagerFactory();

    protected DatagramSocketManager(String name2, OutputStream os, InetAddress inetAddress, String host, int port, Layout<? extends Serializable> layout, int bufferSize) {
        super(name2, os, inetAddress, host, port, layout, true, bufferSize);
    }

    public static DatagramSocketManager getSocketManager(String host, int port, Layout<? extends Serializable> layout, int bufferSize) {
        if (Strings.isEmpty(host)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("A port value is required");
        }
        return (DatagramSocketManager)DatagramSocketManager.getManager("UDP:" + host + ':' + port, new FactoryData(host, port, layout, bufferSize), FACTORY);
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> result2 = new HashMap<String, String>(super.getContentFormat());
        result2.put("protocol", "udp");
        result2.put("direction", "out");
        return result2;
    }

    private static class DatagramSocketManagerFactory
    implements ManagerFactory<DatagramSocketManager, FactoryData> {
        private DatagramSocketManagerFactory() {
        }

        @Override
        public DatagramSocketManager createManager(String name2, FactoryData data2) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(data2.host);
            }
            catch (UnknownHostException ex) {
                LOGGER.error("Could not find address of " + data2.host, (Throwable)ex);
                return null;
            }
            DatagramOutputStream os = new DatagramOutputStream(data2.host, data2.port, data2.layout.getHeader(), data2.layout.getFooter());
            return new DatagramSocketManager(name2, (OutputStream)os, inetAddress, data2.host, data2.port, data2.layout, data2.bufferSize);
        }
    }

    private static class FactoryData {
        private final String host;
        private final int port;
        private final Layout<? extends Serializable> layout;
        private final int bufferSize;

        public FactoryData(String host, int port, Layout<? extends Serializable> layout, int bufferSize) {
            this.host = host;
            this.port = port;
            this.layout = layout;
            this.bufferSize = bufferSize;
        }
    }
}

