/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.core.impl.ExtendedClassInfo;
import org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

class ThrowableProxyHelper {
    private ThrowableProxyHelper() {
    }

    static ExtendedStackTraceElement[] toExtendedStackTrace(ThrowableProxy src, Deque<Class<?>> stack, Map<String, CacheEntry> map2, StackTraceElement[] rootTrace, StackTraceElement[] stackTrace) {
        int stackLength;
        if (rootTrace != null) {
            int stackIndex;
            int rootIndex = rootTrace.length - 1;
            for (stackIndex = stackTrace.length - 1; rootIndex >= 0 && stackIndex >= 0 && rootTrace[rootIndex].equals(stackTrace[stackIndex]); --rootIndex, --stackIndex) {
            }
            src.setCommonElementCount(stackTrace.length - 1 - stackIndex);
            stackLength = stackIndex + 1;
        } else {
            src.setCommonElementCount(0);
            stackLength = stackTrace.length;
        }
        ExtendedStackTraceElement[] extStackTrace = new ExtendedStackTraceElement[stackLength];
        Class<?> clazz = stack.isEmpty() ? null : stack.peek();
        ClassLoader lastLoader = null;
        for (int i = stackLength - 1; i >= 0; --i) {
            ExtendedClassInfo extClassInfo;
            StackTraceElement stackTraceElement = stackTrace[i];
            String className = stackTraceElement.getClassName();
            if (clazz != null && className.equals(clazz.getName())) {
                CacheEntry entry2 = ThrowableProxyHelper.toCacheEntry(clazz, true);
                extClassInfo = entry2.element;
                lastLoader = entry2.loader;
                stack.pop();
                clazz = stack.isEmpty() ? null : stack.peek();
            } else {
                CacheEntry entry3;
                CacheEntry cacheEntry = map2.get(className);
                if (cacheEntry != null) {
                    entry3 = cacheEntry;
                    extClassInfo = entry3.element;
                    if (entry3.loader != null) {
                        lastLoader = entry3.loader;
                    }
                } else {
                    entry3 = ThrowableProxyHelper.toCacheEntry(ThrowableProxyHelper.loadClass(lastLoader, className), false);
                    extClassInfo = entry3.element;
                    map2.put(className, entry3);
                    if (entry3.loader != null) {
                        lastLoader = entry3.loader;
                    }
                }
            }
            extStackTrace[i] = new ExtendedStackTraceElement(stackTraceElement, extClassInfo);
        }
        return extStackTrace;
    }

    static ThrowableProxy[] toSuppressedProxies(Throwable thrown, Set<Throwable> suppressedVisited) {
        try {
            Throwable[] suppressed = thrown.getSuppressed();
            if (suppressed == null || suppressed.length == 0) {
                return ThrowableProxy.EMPTY_ARRAY;
            }
            ArrayList<ThrowableProxy> proxies = new ArrayList<ThrowableProxy>(suppressed.length);
            if (suppressedVisited == null) {
                suppressedVisited = new HashSet<Throwable>(suppressed.length);
            }
            for (int i = 0; i < suppressed.length; ++i) {
                Throwable candidate = suppressed[i];
                if (!suppressedVisited.add(candidate)) continue;
                proxies.add(new ThrowableProxy(candidate, suppressedVisited));
            }
            return proxies.toArray(ThrowableProxy.EMPTY_ARRAY);
        }
        catch (Exception e) {
            StatusLogger.getLogger().error(e);
            return null;
        }
    }

    private static CacheEntry toCacheEntry(Class<?> callerClass, boolean exact) {
        String location = "?";
        String version2 = "?";
        ClassLoader lastLoader = null;
        if (callerClass != null) {
            String ver;
            try {
                URL locationURL;
                CodeSource source = callerClass.getProtectionDomain().getCodeSource();
                if (source != null && (locationURL = source.getLocation()) != null) {
                    String str = locationURL.toString().replace('\\', '/');
                    int index = str.lastIndexOf("/");
                    if (index >= 0 && index == str.length() - 1) {
                        index = str.lastIndexOf("/", index - 1);
                    }
                    location = str.substring(index + 1);
                }
            }
            catch (Exception source) {
                // empty catch block
            }
            Package pkg = callerClass.getPackage();
            if (pkg != null && (ver = pkg.getImplementationVersion()) != null) {
                version2 = ver;
            }
            try {
                lastLoader = callerClass.getClassLoader();
            }
            catch (SecurityException e) {
                lastLoader = null;
            }
        }
        return new CacheEntry(new ExtendedClassInfo(exact, location, version2), lastLoader);
    }

    private static Class<?> loadClass(ClassLoader lastLoader, String className) {
        Class<?> clazz;
        if (lastLoader != null) {
            try {
                clazz = lastLoader.loadClass(className);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            clazz = LoaderUtil.loadClass(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return ThrowableProxyHelper.loadClass(className);
        }
        catch (SecurityException e) {
            return null;
        }
        return clazz;
    }

    private static Class<?> loadClass(String className) {
        try {
            return Loader.loadClass(className, ThrowableProxyHelper.class.getClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError | SecurityException e) {
            return null;
        }
    }

    static final class CacheEntry {
        private final ExtendedClassInfo element;
        private final ClassLoader loader;

        private CacheEntry(ExtendedClassInfo element, ClassLoader loader) {
            this.element = element;
            this.loader = loader;
        }
    }
}

