/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.properties;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.FilterableComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggableComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ScriptComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ScriptFileComponentBuilder;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

public class PropertiesConfigurationBuilder
extends ConfigurationBuilderFactory
implements Builder<PropertiesConfiguration> {
    private static final String ADVERTISER_KEY = "advertiser";
    private static final String STATUS_KEY = "status";
    private static final String SHUTDOWN_HOOK = "shutdownHook";
    private static final String SHUTDOWN_TIMEOUT = "shutdownTimeout";
    private static final String VERBOSE = "verbose";
    private static final String DEST = "dest";
    private static final String PACKAGES = "packages";
    private static final String CONFIG_NAME = "name";
    private static final String MONITOR_INTERVAL = "monitorInterval";
    private static final String CONFIG_TYPE = "type";
    private final ConfigurationBuilder<PropertiesConfiguration> builder = PropertiesConfigurationBuilder.newConfigurationBuilder(PropertiesConfiguration.class);
    private LoggerContext loggerContext;
    private Properties rootProperties;

    public PropertiesConfigurationBuilder setRootProperties(Properties rootProperties) {
        this.rootProperties = rootProperties;
        return this;
    }

    public PropertiesConfigurationBuilder setConfigurationSource(ConfigurationSource source) {
        this.builder.setConfigurationSource(source);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PropertiesConfiguration build() {
        String loggerProp;
        String appenderProp;
        String string;
        Object type2;
        for (String string2 : this.rootProperties.stringPropertyNames()) {
            if (string2.contains(".")) continue;
            this.builder.addRootProperty(string2, this.rootProperties.getProperty(string2));
        }
        this.builder.setStatusLevel(Level.toLevel(this.rootProperties.getProperty(STATUS_KEY), Level.ERROR)).setShutdownHook(this.rootProperties.getProperty(SHUTDOWN_HOOK)).setShutdownTimeout(Long.parseLong(this.rootProperties.getProperty(SHUTDOWN_TIMEOUT, "0")), TimeUnit.MILLISECONDS).setVerbosity(this.rootProperties.getProperty(VERBOSE)).setDestination(this.rootProperties.getProperty(DEST)).setPackages(this.rootProperties.getProperty(PACKAGES)).setConfigurationName(this.rootProperties.getProperty(CONFIG_NAME)).setMonitorInterval(this.rootProperties.getProperty(MONITOR_INTERVAL, "0")).setAdvertiser(this.rootProperties.getProperty(ADVERTISER_KEY));
        Properties propertyPlaceholders = PropertiesUtil.extractSubset(this.rootProperties, "property");
        for (String string3 : propertyPlaceholders.stringPropertyNames()) {
            this.builder.addProperty(string3, propertyPlaceholders.getProperty(string3));
        }
        Map<String, Properties> map2 = PropertiesUtil.partitionOnCommonPrefixes(PropertiesUtil.extractSubset(this.rootProperties, "script"));
        for (Map.Entry<String, Properties> entry2 : map2.entrySet()) {
            Properties scriptProps = entry2.getValue();
            type2 = (String[])scriptProps.remove(CONFIG_TYPE);
            if (type2 == null) {
                throw new ConfigurationException("No type provided for script - must be Script or ScriptFile");
            }
            if (((String)type2).equalsIgnoreCase("script")) {
                this.builder.add(this.createScript(scriptProps));
                continue;
            }
            this.builder.add(this.createScriptFile(scriptProps));
        }
        Properties properties2 = PropertiesUtil.extractSubset(this.rootProperties, "customLevel");
        if (properties2.size() > 0) {
            for (String key : properties2.stringPropertyNames()) {
                this.builder.add(this.builder.newCustomLevel(key, Integers.parseInt(properties2.getProperty(key))));
            }
        }
        if ((string = this.rootProperties.getProperty("filters")) != null) {
            void var8_24;
            String[] filterNames = string.split(",");
            type2 = filterNames;
            int n = ((String[])type2).length;
            boolean bl = false;
            while (var8_24 < n) {
                Object object = type2[var8_24];
                String name2 = ((String)object).trim();
                this.builder.add(this.createFilter(name2, PropertiesUtil.extractSubset(this.rootProperties, "filter." + name2)));
                ++var8_24;
            }
        } else {
            Map<String, Properties> filters = PropertiesUtil.partitionOnCommonPrefixes(PropertiesUtil.extractSubset(this.rootProperties, "filter"));
            for (Map.Entry entry3 : filters.entrySet()) {
                this.builder.add(this.createFilter(((String)entry3.getKey()).trim(), (Properties)entry3.getValue()));
            }
        }
        if ((appenderProp = this.rootProperties.getProperty("appenders")) != null) {
            void var9_33;
            String[] appenderNames;
            String[] stringArray = appenderNames = appenderProp.split(",");
            int n = stringArray.length;
            boolean bl = false;
            while (var9_33 < n) {
                String appenderName = stringArray[var9_33];
                String name3 = appenderName.trim();
                this.builder.add(this.createAppender(appenderName.trim(), PropertiesUtil.extractSubset(this.rootProperties, "appender." + name3)));
                ++var9_33;
            }
        } else {
            Map<String, Properties> appenders = PropertiesUtil.partitionOnCommonPrefixes(PropertiesUtil.extractSubset(this.rootProperties, "appender"));
            for (Map.Entry<String, Properties> entry4 : appenders.entrySet()) {
                this.builder.add(this.createAppender(entry4.getKey().trim(), entry4.getValue()));
            }
        }
        if ((loggerProp = this.rootProperties.getProperty("loggers")) != null) {
            String[] stringArray;
            for (String loggerName : stringArray = loggerProp.split(",")) {
                String name4 = loggerName.trim();
                if (name4.equals("root")) continue;
                this.builder.add(this.createLogger(name4, PropertiesUtil.extractSubset(this.rootProperties, "logger." + name4)));
            }
        } else {
            Map<String, Properties> map3 = PropertiesUtil.partitionOnCommonPrefixes(PropertiesUtil.extractSubset(this.rootProperties, "logger"), true);
            for (Map.Entry<String, Properties> entry5 : map3.entrySet()) {
                String name2 = entry5.getKey().trim();
                if (name2.equals("root")) continue;
                this.builder.add(this.createLogger(name2, entry5.getValue()));
            }
        }
        String string4 = this.rootProperties.getProperty("rootLogger");
        Properties properties3 = PropertiesUtil.extractSubset(this.rootProperties, "rootLogger");
        if (string4 != null) {
            properties3.setProperty("", string4);
            this.rootProperties.remove("rootLogger");
        }
        if (properties3.size() > 0) {
            this.builder.add(this.createRootLogger(properties3));
        }
        this.builder.setLoggerContext(this.loggerContext);
        return this.builder.build(false);
    }

    private ScriptComponentBuilder createScript(Properties properties2) {
        String name2 = (String)properties2.remove(CONFIG_NAME);
        String language = (String)properties2.remove("language");
        String text = (String)properties2.remove("text");
        ScriptComponentBuilder scriptBuilder = this.builder.newScript(name2, language, text);
        return PropertiesConfigurationBuilder.processRemainingProperties(scriptBuilder, properties2);
    }

    private ScriptFileComponentBuilder createScriptFile(Properties properties2) {
        String name2 = (String)properties2.remove(CONFIG_NAME);
        String path = (String)properties2.remove("path");
        ScriptFileComponentBuilder scriptFileBuilder = this.builder.newScriptFile(name2, path);
        return PropertiesConfigurationBuilder.processRemainingProperties(scriptFileBuilder, properties2);
    }

    private AppenderComponentBuilder createAppender(String key, Properties properties2) {
        String name2 = (String)properties2.remove(CONFIG_NAME);
        if (Strings.isEmpty(name2)) {
            throw new ConfigurationException("No name attribute provided for Appender " + key);
        }
        String type2 = (String)properties2.remove(CONFIG_TYPE);
        if (Strings.isEmpty(type2)) {
            throw new ConfigurationException("No type attribute provided for Appender " + key);
        }
        AppenderComponentBuilder appenderBuilder = this.builder.newAppender(name2, type2);
        this.addFiltersToComponent(appenderBuilder, properties2);
        Properties layoutProps = PropertiesUtil.extractSubset(properties2, "layout");
        if (layoutProps.size() > 0) {
            appenderBuilder.add(this.createLayout(name2, layoutProps));
        }
        return PropertiesConfigurationBuilder.processRemainingProperties(appenderBuilder, properties2);
    }

    private FilterComponentBuilder createFilter(String key, Properties properties2) {
        String type2 = (String)properties2.remove(CONFIG_TYPE);
        if (Strings.isEmpty(type2)) {
            throw new ConfigurationException("No type attribute provided for Filter " + key);
        }
        String onMatch = (String)properties2.remove("onMatch");
        String onMismatch = (String)properties2.remove("onMismatch");
        FilterComponentBuilder filterBuilder = this.builder.newFilter(type2, onMatch, onMismatch);
        return PropertiesConfigurationBuilder.processRemainingProperties(filterBuilder, properties2);
    }

    private AppenderRefComponentBuilder createAppenderRef(String key, Properties properties2) {
        String ref = (String)properties2.remove("ref");
        if (Strings.isEmpty(ref)) {
            throw new ConfigurationException("No ref attribute provided for AppenderRef " + key);
        }
        AppenderRefComponentBuilder appenderRefBuilder = this.builder.newAppenderRef(ref);
        String level = Strings.trimToNull((String)properties2.remove("level"));
        if (!Strings.isEmpty(level)) {
            appenderRefBuilder.addAttribute("level", level);
        }
        return this.addFiltersToComponent(appenderRefBuilder, properties2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LoggerComponentBuilder createLogger(String key, Properties properties2) {
        LoggerComponentBuilder loggerBuilder;
        String levelAndRefs = properties2.getProperty("");
        String name2 = (String)properties2.remove(CONFIG_NAME);
        String location = (String)properties2.remove("includeLocation");
        if (Strings.isEmpty(name2)) {
            throw new ConfigurationException("No name attribute provided for Logger " + key);
        }
        String level = Strings.trimToNull((String)properties2.remove("level"));
        String type2 = (String)properties2.remove(CONFIG_TYPE);
        if (type2 != null) {
            if (!type2.equalsIgnoreCase("asyncLogger")) throw new ConfigurationException("Unknown Logger type " + type2 + " for Logger " + name2);
            if (location != null) {
                boolean includeLocation = Boolean.parseBoolean(location);
                loggerBuilder = this.builder.newAsyncLogger(name2, level, includeLocation);
            } else {
                loggerBuilder = this.builder.newAsyncLogger(name2, level);
            }
        } else if (location != null) {
            boolean includeLocation = Boolean.parseBoolean(location);
            loggerBuilder = this.builder.newLogger(name2, level, includeLocation);
        } else {
            loggerBuilder = this.builder.newLogger(name2, level);
        }
        this.addLoggersToComponent(loggerBuilder, properties2);
        this.addFiltersToComponent(loggerBuilder, properties2);
        String additivity = (String)properties2.remove("additivity");
        if (!Strings.isEmpty(additivity)) {
            loggerBuilder.addAttribute("additivity", additivity);
        }
        if (levelAndRefs == null) return loggerBuilder;
        loggerBuilder.addAttribute("levelAndRefs", levelAndRefs);
        return loggerBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RootLoggerComponentBuilder createRootLogger(Properties properties2) {
        RootLoggerComponentBuilder loggerBuilder;
        String levelAndRefs = properties2.getProperty("");
        String level = Strings.trimToNull((String)properties2.remove("level"));
        String type2 = (String)properties2.remove(CONFIG_TYPE);
        String location = (String)properties2.remove("includeLocation");
        if (type2 != null) {
            if (!type2.equalsIgnoreCase("asyncRoot")) throw new ConfigurationException("Unknown Logger type for root logger" + type2);
            if (location != null) {
                boolean includeLocation = Boolean.parseBoolean(location);
                loggerBuilder = this.builder.newAsyncRootLogger(level, includeLocation);
            } else {
                loggerBuilder = this.builder.newAsyncRootLogger(level);
            }
        } else if (location != null) {
            boolean includeLocation = Boolean.parseBoolean(location);
            loggerBuilder = this.builder.newRootLogger(level, includeLocation);
        } else {
            loggerBuilder = this.builder.newRootLogger(level);
        }
        this.addLoggersToComponent(loggerBuilder, properties2);
        if (levelAndRefs == null) return this.addFiltersToComponent(loggerBuilder, properties2);
        loggerBuilder.addAttribute("levelAndRefs", levelAndRefs);
        return this.addFiltersToComponent(loggerBuilder, properties2);
    }

    private LayoutComponentBuilder createLayout(String appenderName, Properties properties2) {
        String type2 = (String)properties2.remove(CONFIG_TYPE);
        if (Strings.isEmpty(type2)) {
            throw new ConfigurationException("No type attribute provided for Layout on Appender " + appenderName);
        }
        LayoutComponentBuilder layoutBuilder = this.builder.newLayout(type2);
        return PropertiesConfigurationBuilder.processRemainingProperties(layoutBuilder, properties2);
    }

    private static <B extends ComponentBuilder<B>> ComponentBuilder<B> createComponent(ComponentBuilder<?> parent, String key, Properties properties2) {
        String name2 = (String)properties2.remove(CONFIG_NAME);
        String type2 = (String)properties2.remove(CONFIG_TYPE);
        if (Strings.isEmpty(type2)) {
            throw new ConfigurationException("No type attribute provided for component " + key);
        }
        ComponentBuilder componentBuilder = parent.getBuilder().newComponent(name2, type2);
        return PropertiesConfigurationBuilder.processRemainingProperties(componentBuilder, properties2);
    }

    private static <B extends ComponentBuilder<?>> B processRemainingProperties(B builder, Properties properties2) {
        while (properties2.size() > 0) {
            String propertyName = properties2.stringPropertyNames().iterator().next();
            int index = propertyName.indexOf(46);
            if (index > 0) {
                String prefix = propertyName.substring(0, index);
                Properties componentProperties = PropertiesUtil.extractSubset(properties2, prefix);
                builder.addComponent(PropertiesConfigurationBuilder.createComponent(builder, prefix, componentProperties));
                continue;
            }
            builder.addAttribute(propertyName, properties2.getProperty(propertyName));
            properties2.remove(propertyName);
        }
        return builder;
    }

    private <B extends FilterableComponentBuilder<? extends ComponentBuilder<?>>> B addFiltersToComponent(B componentBuilder, Properties properties2) {
        Map<String, Properties> filters = PropertiesUtil.partitionOnCommonPrefixes(PropertiesUtil.extractSubset(properties2, "filter"));
        for (Map.Entry<String, Properties> entry2 : filters.entrySet()) {
            componentBuilder.add(this.createFilter(entry2.getKey().trim(), entry2.getValue()));
        }
        return componentBuilder;
    }

    private <B extends LoggableComponentBuilder<? extends ComponentBuilder<?>>> B addLoggersToComponent(B loggerBuilder, Properties properties2) {
        Map<String, Properties> appenderRefs = PropertiesUtil.partitionOnCommonPrefixes(PropertiesUtil.extractSubset(properties2, "appenderRef"));
        for (Map.Entry<String, Properties> entry2 : appenderRefs.entrySet()) {
            loggerBuilder.add(this.createAppenderRef(entry2.getKey().trim(), entry2.getValue()));
        }
        return loggerBuilder;
    }

    public PropertiesConfigurationBuilder setLoggerContext(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
        return this;
    }

    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }
}

