/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive
public class AppenderControlArraySet {
    private static final AtomicReferenceFieldUpdater<AppenderControlArraySet, AppenderControl[]> appenderArrayUpdater = AtomicReferenceFieldUpdater.newUpdater(AppenderControlArraySet.class, AppenderControl[].class, "appenderArray");
    private volatile AppenderControl[] appenderArray = AppenderControl.EMPTY_ARRAY;

    public boolean add(AppenderControl control) {
        AppenderControl[] copy2;
        AppenderControl[] original;
        boolean success;
        do {
            for (AppenderControl existing : original = this.appenderArray) {
                if (!existing.equals(control)) continue;
                return false;
            }
            copy2 = Arrays.copyOf(original, original.length + 1);
            copy2[copy2.length - 1] = control;
        } while (!(success = appenderArrayUpdater.compareAndSet(this, original, copy2)));
        return true;
    }

    public AppenderControl remove(String name2) {
        boolean success;
        block0: do {
            success = true;
            AppenderControl[] original = this.appenderArray;
            for (int i = 0; i < original.length; ++i) {
                AppenderControl appenderControl = original[i];
                if (!Objects.equals(name2, appenderControl.getAppenderName())) continue;
                AppenderControl[] copy2 = this.removeElementAt(i, original);
                if (appenderArrayUpdater.compareAndSet(this, original, copy2)) {
                    return appenderControl;
                }
                success = false;
                continue block0;
            }
        } while (!success);
        return null;
    }

    private AppenderControl[] removeElementAt(int i, AppenderControl[] array) {
        AppenderControl[] result2 = Arrays.copyOf(array, array.length - 1);
        System.arraycopy(array, i + 1, result2, i, result2.length - i);
        return result2;
    }

    public Map<String, Appender> asMap() {
        HashMap<String, Appender> result2 = new HashMap<String, Appender>();
        for (AppenderControl appenderControl : this.appenderArray) {
            result2.put(appenderControl.getAppenderName(), appenderControl.getAppender());
        }
        return result2;
    }

    public AppenderControl[] clear() {
        return appenderArrayUpdater.getAndSet(this, AppenderControl.EMPTY_ARRAY);
    }

    public boolean isEmpty() {
        return this.appenderArray.length == 0;
    }

    public AppenderControl[] get() {
        return this.appenderArray;
    }

    public String toString() {
        return "AppenderControlArraySet [appenderArray=" + Arrays.toString(this.appenderArray) + "]";
    }
}

