/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLogger;
import org.apache.logging.log4j.core.async.AsyncLoggerDisruptor;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.status.StatusLogger;

public class AsyncLoggerContext
extends LoggerContext {
    private final AsyncLoggerDisruptor loggerDisruptor;

    public AsyncLoggerContext(String name2) {
        super(name2);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name2, () -> this.getConfiguration().getAsyncWaitStrategyFactory());
    }

    public AsyncLoggerContext(String name2, Object externalContext) {
        super(name2, externalContext);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name2, () -> this.getConfiguration().getAsyncWaitStrategyFactory());
    }

    public AsyncLoggerContext(String name2, Object externalContext, URI configLocn) {
        super(name2, externalContext, configLocn);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name2, () -> this.getConfiguration().getAsyncWaitStrategyFactory());
    }

    public AsyncLoggerContext(String name2, Object externalContext, String configLocn) {
        super(name2, externalContext, configLocn);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name2, () -> this.getConfiguration().getAsyncWaitStrategyFactory());
    }

    @Override
    protected Logger newInstance(LoggerContext ctx, String name2, MessageFactory messageFactory) {
        return new AsyncLogger(ctx, name2, messageFactory, this.loggerDisruptor);
    }

    @Override
    public void setName(String name2) {
        super.setName("AsyncContext[" + name2 + "]");
        this.loggerDisruptor.setContextName(name2);
    }

    @Override
    public void start() {
        this.loggerDisruptor.start();
        super.start();
    }

    @Override
    public void start(Configuration config) {
        this.maybeStartHelper(config);
        super.start(config);
    }

    private void maybeStartHelper(Configuration config) {
        if (config instanceof DefaultConfiguration) {
            StatusLogger.getLogger().debug("[{}] Not starting Disruptor for DefaultConfiguration.", (Object)this.getName());
        } else {
            this.loggerDisruptor.start();
        }
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        this.loggerDisruptor.stop(timeout, timeUnit);
        super.stop(timeout, timeUnit);
        return true;
    }

    public RingBufferAdmin createRingBufferAdmin() {
        return this.loggerDisruptor.createRingBufferAdmin(this.getName());
    }

    public void setUseThreadLocals(boolean useThreadLocals) {
        this.loggerDisruptor.setUseThreadLocals(useThreadLocals);
    }
}

