/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.parser.VMSFTPEntryParser;

public class VMSVersioningFTPEntryParser
extends VMSFTPEntryParser {
    private final Pattern _preparse_pattern_;
    private static final String PRE_PARSE_REGEX = "(.*?);([0-9]+)\\s*.*";

    public VMSVersioningFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public VMSVersioningFTPEntryParser(FTPClientConfig config) {
        this.configure(config);
        try {
            this._preparse_pattern_ = Pattern.compile(PRE_PARSE_REGEX);
        }
        catch (PatternSyntaxException pse) {
            throw new IllegalArgumentException("Unparseable regex supplied:  (.*?);([0-9]+)\\s*.*");
        }
    }

    @Override
    public List<String> preParse(List<String> original) {
        Integer existing;
        Integer nv;
        String version2;
        String name2;
        Matcher _preparse_matcher_;
        MatchResult result2;
        String entry2;
        HashMap<String, Integer> existingEntries = new HashMap<String, Integer>();
        ListIterator<String> iter2 = original.listIterator();
        while (iter2.hasNext()) {
            entry2 = iter2.next().trim();
            result2 = null;
            _preparse_matcher_ = this._preparse_pattern_.matcher(entry2);
            if (!_preparse_matcher_.matches()) continue;
            result2 = _preparse_matcher_.toMatchResult();
            name2 = result2.group(1);
            version2 = result2.group(2);
            nv = Integer.valueOf(version2);
            existing = (Integer)existingEntries.get(name2);
            if (null != existing && nv < existing) {
                iter2.remove();
                continue;
            }
            existingEntries.put(name2, nv);
        }
        while (iter2.hasPrevious()) {
            entry2 = iter2.previous().trim();
            result2 = null;
            _preparse_matcher_ = this._preparse_pattern_.matcher(entry2);
            if (!_preparse_matcher_.matches()) continue;
            result2 = _preparse_matcher_.toMatchResult();
            name2 = result2.group(1);
            version2 = result2.group(2);
            nv = Integer.valueOf(version2);
            existing = (Integer)existingEntries.get(name2);
            if (null == existing || nv >= existing) continue;
            iter2.remove();
        }
        return original;
    }

    @Override
    protected boolean isVersioning() {
        return true;
    }
}

