/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biomes;

import java.util.Map;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.ItemStack;
import net.minestom.server.utils.NamespaceID;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

public record BiomeParticle(float probability, Option option) {
    public NBTCompound toNbt() {
        return NBT.Compound(Map.of("probability", NBT.Float(this.probability), "options", this.option.toNbt()));
    }

    public static interface Option {
        public NBTCompound toNbt();
    }

    public record NormalOption(NamespaceID type) implements Option
    {
        @Override
        public NBTCompound toNbt() {
            return NBT.Compound(Map.of("type", NBT.String(this.type.toString())));
        }
    }

    public record ItemOption(ItemStack item) implements Option
    {
        private static final String type = "item";

        @Override
        public NBTCompound toNbt() {
            NBTCompound nbtCompound = this.item.meta().toNBT();
            return nbtCompound.modify(n -> n.setString("type", type));
        }
    }

    public record DustOption(float red, float green, float blue, float scale) implements Option
    {
        private static final String type = "dust";

        @Override
        public NBTCompound toNbt() {
            return NBT.Compound(Map.of("type", NBT.String(type), "r", NBT.Float(this.red), "g", NBT.Float(this.green), "b", NBT.Float(this.blue), "scale", NBT.Float(this.scale)));
        }
    }

    public record BlockOption(Block block) implements Option
    {
        private static final String type = "block";

        @Override
        public NBTCompound toNbt() {
            return NBT.Compound(nbtCompound -> {
                nbtCompound.setString("type", type);
                nbtCompound.setString("Name", this.block.name());
                Map<String, String> propertiesMap = this.block.properties();
                if (propertiesMap.size() != 0) {
                    nbtCompound.set("Properties", NBT.Compound(p -> propertiesMap.forEach(p::setString)));
                }
            });
        }
    }
}

