/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biomes;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.world.biomes.Biome;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTType;

public final class BiomeManager {
    private final Int2ObjectMap<Biome> biomes = new Int2ObjectOpenHashMap<Biome>();

    public BiomeManager() {
        this.addBiome(Biome.PLAINS);
    }

    public synchronized void addBiome(Biome biome) {
        this.biomes.put(biome.id(), biome);
    }

    public synchronized void removeBiome(Biome biome) {
        this.biomes.remove(biome.id());
    }

    public synchronized Collection<Biome> unmodifiableCollection() {
        return Collections.unmodifiableCollection(this.biomes.values());
    }

    public synchronized Biome getById(int id2) {
        return (Biome)this.biomes.get(id2);
    }

    public synchronized Biome getByName(NamespaceID namespaceID) {
        Biome biome = null;
        for (Biome biomeT : this.biomes.values()) {
            if (!biomeT.name().equals(namespaceID)) continue;
            biome = biomeT;
            break;
        }
        return biome;
    }

    public synchronized NBTCompound toNBT() {
        return NBT.Compound(Map.of("type", NBT.String("minecraft:worldgen/biome"), "value", NBT.List(NBTType.TAG_Compound, this.biomes.values().stream().map(Biome::toNbt).toList())));
    }
}

