/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.mcdata.SizesKt;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

public class DimensionType {
    private static final AtomicInteger idCounter = new AtomicInteger(0);
    public static final DimensionType OVERWORLD = DimensionType.builder(NamespaceID.from("minecraft:overworld")).ultrawarm(false).natural(true).piglinSafe(false).respawnAnchorSafe(false).bedSafe(true).raidCapable(true).skylightEnabled(true).ceilingEnabled(false).fixedTime(null).ambientLight(0.0f).height(384).minY(-64).logicalHeight(384).infiniburn(NamespaceID.from("minecraft:infiniburn_overworld")).build();
    private final int id = idCounter.getAndIncrement();
    protected volatile boolean registered;
    private final NamespaceID name;
    private final boolean natural;
    private final float ambientLight;
    private final boolean ceilingEnabled;
    private final boolean skylightEnabled;
    @Nullable
    private final Long fixedTime;
    private final boolean raidCapable;
    private final boolean respawnAnchorSafe;
    private final boolean ultrawarm;
    private final boolean bedSafe;
    private final String effects;
    private final boolean piglinSafe;
    private final int minY;
    private final int height;
    private final int logicalHeight;
    private final double coordinateScale;
    private final NamespaceID infiniburn;

    DimensionType(NamespaceID name2, boolean natural, float ambientLight, boolean ceilingEnabled, boolean skylightEnabled, @Nullable Long fixedTime, boolean raidCapable, boolean respawnAnchorSafe, boolean ultrawarm, boolean bedSafe, String effects, boolean piglinSafe, int minY, int height, int logicalHeight, double coordinateScale, NamespaceID infiniburn) {
        this.name = name2;
        this.natural = natural;
        this.ambientLight = ambientLight;
        this.ceilingEnabled = ceilingEnabled;
        this.skylightEnabled = skylightEnabled;
        this.fixedTime = fixedTime;
        this.raidCapable = raidCapable;
        this.respawnAnchorSafe = respawnAnchorSafe;
        this.ultrawarm = ultrawarm;
        this.bedSafe = bedSafe;
        this.effects = effects;
        this.piglinSafe = piglinSafe;
        this.minY = minY;
        this.height = height;
        this.logicalHeight = logicalHeight;
        this.coordinateScale = coordinateScale;
        this.infiniburn = infiniburn;
    }

    public static DimensionTypeBuilder builder(NamespaceID name2) {
        return DimensionType.hiddenBuilder().name(name2);
    }

    public static DimensionTypeBuilder hiddenBuilder() {
        return new DimensionTypeBuilder();
    }

    public static DimensionType fromNBT(NBTCompound nbt) {
        return DimensionType.builder(NamespaceID.from(nbt.getString("name"))).ambientLight(nbt.getFloat("ambient_light").floatValue()).infiniburn(NamespaceID.from(nbt.getString("infiniburn").replaceFirst("#", ""))).natural(nbt.getByte("natural") != 0).ceilingEnabled(nbt.getByte("has_ceiling") != 0).skylightEnabled(nbt.getByte("has_skylight") != 0).ultrawarm(nbt.getByte("ultrawarm") != 0).raidCapable(nbt.getByte("has_raids") != 0).respawnAnchorSafe(nbt.getByte("respawn_anchor_works") != 0).bedSafe(nbt.getByte("bed_works") != 0).effects(nbt.getString("effects")).piglinSafe(nbt.getByte("piglin_safe") != 0).logicalHeight(nbt.getInt("logical_height")).coordinateScale(nbt.getDouble("coordinate_scale")).build();
    }

    @NotNull
    public NBTCompound toIndexedNBT() {
        return NBT.Compound(Map.of("name", NBT.String(this.name.toString()), "id", NBT.Int(this.id), "element", this.toNBT()));
    }

    @NotNull
    public NBTCompound toNBT() {
        return NBT.Compound(nbt -> {
            nbt.setFloat("ambient_light", this.ambientLight);
            nbt.setString("infiniburn", "#" + this.infiniburn.toString());
            nbt.setByte("natural", (byte)(this.natural ? 1 : 0));
            nbt.setByte("has_ceiling", (byte)(this.ceilingEnabled ? 1 : 0));
            nbt.setByte("has_skylight", (byte)(this.skylightEnabled ? 1 : 0));
            nbt.setByte("ultrawarm", (byte)(this.ultrawarm ? 1 : 0));
            nbt.setByte("has_raids", (byte)(this.raidCapable ? 1 : 0));
            nbt.setByte("respawn_anchor_works", (byte)(this.respawnAnchorSafe ? 1 : 0));
            nbt.setByte("bed_works", (byte)(this.bedSafe ? 1 : 0));
            nbt.setString("effects", this.effects);
            nbt.setByte("piglin_safe", (byte)(this.piglinSafe ? 1 : 0));
            nbt.setInt("min_y", this.minY);
            nbt.setInt("height", this.height);
            nbt.setInt("logical_height", this.logicalHeight);
            nbt.setDouble("coordinate_scale", this.coordinateScale);
            nbt.setString("name", this.name.toString());
            nbt.setInt("monster_spawn_block_light_limit", 0);
            nbt.setInt("monster_spawn_light_level", 11);
            if (this.fixedTime != null) {
                nbt.setLong("fixed_time", this.fixedTime);
            }
        });
    }

    public String toString() {
        return this.name.toString();
    }

    public int getId() {
        return this.id;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public NamespaceID getName() {
        return this.name;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public float getAmbientLight() {
        return this.ambientLight;
    }

    public boolean isCeilingEnabled() {
        return this.ceilingEnabled;
    }

    public boolean isSkylightEnabled() {
        return this.skylightEnabled;
    }

    @Nullable
    public Long getFixedTime() {
        return this.fixedTime;
    }

    public boolean isRaidCapable() {
        return this.raidCapable;
    }

    public boolean isRespawnAnchorSafe() {
        return this.respawnAnchorSafe;
    }

    public boolean isUltrawarm() {
        return this.ultrawarm;
    }

    public boolean isBedSafe() {
        return this.bedSafe;
    }

    public String getEffects() {
        return this.effects;
    }

    public boolean isPiglinSafe() {
        return this.piglinSafe;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxY() {
        return this.getMinY() + this.getHeight();
    }

    public int getLogicalHeight() {
        return this.logicalHeight;
    }

    public double getCoordinateScale() {
        return this.coordinateScale;
    }

    public NamespaceID getInfiniburn() {
        return this.infiniburn;
    }

    public int getTotalHeight() {
        return this.minY + this.height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionType that = (DimensionType)o;
        return this.id == that.id && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public static class DimensionTypeBuilder {
        private NamespaceID name;
        private boolean natural;
        private float ambientLight;
        private boolean ceilingEnabled;
        private boolean skylightEnabled;
        @Nullable
        private Long fixedTime = null;
        private boolean raidCapable;
        private boolean respawnAnchorSafe;
        private boolean ultrawarm;
        private boolean bedSafe = true;
        private String effects = "minecraft:overworld";
        private boolean piglinSafe = false;
        private int minY = SizesKt.getVanillaMinY();
        private int logicalHeight = SizesKt.getVanillaMaxY() - SizesKt.getVanillaMinY() + 1;
        private int height = SizesKt.getVanillaMaxY() - SizesKt.getVanillaMinY() + 1;
        private double coordinateScale = 1.0;
        private NamespaceID infiniburn = NamespaceID.from("minecraft:infiniburn_overworld");

        DimensionTypeBuilder() {
        }

        public DimensionTypeBuilder name(NamespaceID name2) {
            this.name = name2;
            return this;
        }

        public DimensionTypeBuilder natural(boolean natural) {
            this.natural = natural;
            return this;
        }

        public DimensionTypeBuilder ambientLight(float ambientLight) {
            this.ambientLight = ambientLight;
            return this;
        }

        public DimensionTypeBuilder ceilingEnabled(boolean ceilingEnabled) {
            this.ceilingEnabled = ceilingEnabled;
            return this;
        }

        public DimensionTypeBuilder skylightEnabled(boolean skylightEnabled) {
            this.skylightEnabled = skylightEnabled;
            return this;
        }

        public DimensionTypeBuilder fixedTime(Long fixedTime) {
            this.fixedTime = fixedTime;
            return this;
        }

        public DimensionTypeBuilder raidCapable(boolean raidCapable) {
            this.raidCapable = raidCapable;
            return this;
        }

        public DimensionTypeBuilder respawnAnchorSafe(boolean respawnAnchorSafe) {
            this.respawnAnchorSafe = respawnAnchorSafe;
            return this;
        }

        public DimensionTypeBuilder ultrawarm(boolean ultrawarm) {
            this.ultrawarm = ultrawarm;
            return this;
        }

        public DimensionTypeBuilder bedSafe(boolean bedSafe) {
            this.bedSafe = bedSafe;
            return this;
        }

        public DimensionTypeBuilder effects(String effects) {
            this.effects = effects;
            return this;
        }

        public DimensionTypeBuilder piglinSafe(boolean piglinSafe) {
            this.piglinSafe = piglinSafe;
            return this;
        }

        public DimensionTypeBuilder minY(int minY) {
            this.minY = minY;
            return this;
        }

        public DimensionTypeBuilder height(int height) {
            this.height = height;
            return this;
        }

        public DimensionTypeBuilder logicalHeight(int logicalHeight) {
            this.logicalHeight = logicalHeight;
            return this;
        }

        public DimensionTypeBuilder coordinateScale(double coordinateScale) {
            this.coordinateScale = coordinateScale;
            return this;
        }

        public DimensionTypeBuilder infiniburn(NamespaceID infiniburn) {
            this.infiniburn = infiniburn;
            return this;
        }

        public DimensionType build() {
            return new DimensionType(this.name, this.natural, this.ambientLight, this.ceilingEnabled, this.skylightEnabled, this.fixedTime, this.raidCapable, this.respawnAnchorSafe, this.ultrawarm, this.bedSafe, this.effects, this.piglinSafe, this.minY, this.height, this.logicalHeight, this.coordinateScale, this.infiniburn);
        }
    }
}

