/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.validate;

import java.text.MessageFormat;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Check {
    private Check() {
    }

    @Contract(value="null, _ -> fail")
    public static void notNull(@Nullable Object object, @NotNull String reason) {
        if (Objects.isNull(object)) {
            throw new NullPointerException(reason);
        }
    }

    @Contract(value="null, _, _ -> fail")
    public static void notNull(@Nullable Object object, @NotNull String reason, Object ... arguments2) {
        if (Objects.isNull(object)) {
            throw new NullPointerException(MessageFormat.format(reason, arguments2));
        }
    }

    @Contract(value="true, _ -> fail")
    public static void argCondition(boolean condition, @NotNull String reason) {
        if (condition) {
            throw new IllegalArgumentException(reason);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void argCondition(boolean condition, @NotNull String reason, Object ... arguments2) {
        if (condition) {
            throw new IllegalArgumentException(MessageFormat.format(reason, arguments2));
        }
    }

    @Contract(value="_ -> fail")
    public static void fail(@NotNull String reason) {
        throw new IllegalArgumentException(reason);
    }

    @Contract(value="true, _ -> fail")
    public static void stateCondition(boolean condition, @NotNull String reason) {
        if (condition) {
            throw new IllegalStateException(reason);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void stateCondition(boolean condition, @NotNull String reason, Object ... arguments2) {
        if (condition) {
            throw new IllegalStateException(MessageFormat.format(reason, arguments2));
        }
    }
}

