/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.position;

import net.minestom.server.coordinate.Pos;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PositionUtils {
    public static Pos lookAlong(@NotNull Pos position, double dx, double dy, double dz) {
        float yaw = PositionUtils.getLookYaw(dx, dz);
        float pitch = PositionUtils.getLookPitch(dx, dy, dz);
        return position.withView(yaw, pitch);
    }

    public static float getLookYaw(double dx, double dz) {
        double radians2 = Math.atan2(dz, dx);
        float degrees2 = (float)Math.toDegrees(radians2) - 90.0f;
        if (degrees2 < -180.0f) {
            return degrees2 + 360.0f;
        }
        if (degrees2 > 180.0f) {
            return degrees2 - 360.0f;
        }
        return degrees2;
    }

    public static float getLookPitch(double dx, double dy, double dz) {
        double radians2 = -Math.atan2(dy, Math.max(Math.abs(dx), Math.abs(dz)));
        return (float)Math.toDegrees(radians2);
    }
}

