/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.mojang;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.minestom.server.MinecraftServer;
import net.minestom.server.utils.url.URLUtils;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MojangUtils {
    private static final String FROM_UUID_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false";
    private static final String FROM_USERNAME_URL = "https://api.mojang.com/users/profiles/minecraft/%s";
    private static final Cache<String, JsonObject> URL_CACHE = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).softValues().build();

    @Blocking
    @Nullable
    public static JsonObject fromUuid(@NotNull String uuid) {
        return MojangUtils.retrieve(String.format(FROM_UUID_URL, uuid));
    }

    @Blocking
    @Nullable
    public static JsonObject fromUsername(@NotNull String username) {
        return MojangUtils.retrieve(String.format(FROM_USERNAME_URL, username));
    }

    @Nullable
    private static JsonObject retrieve(@NotNull String url2) {
        return URL_CACHE.get(url2, s2 -> {
            try {
                String response = URLUtils.getText(url2);
                if (response.isEmpty()) {
                    return null;
                }
                return JsonParser.parseString(response).getAsJsonObject();
            }
            catch (IOException e) {
                MinecraftServer.getExceptionManager().handleException(e);
                throw new RuntimeException(e);
            }
        });
    }
}

