/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.crypto;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class KeyUtils {
    private static final Base64.Encoder MIME_ENCODER = Base64.getMimeEncoder(76, "\n".getBytes(StandardCharsets.UTF_8));
    private static final String RSA_HEADER = "-----BEGIN RSA PUBLIC KEY-----\n";
    private static final String RSA_FOOTER = "\n-----END RSA PUBLIC KEY-----\n";

    private KeyUtils() {
    }

    public static String rsaPublicKeyToString(PublicKey publicKey) {
        if (!publicKey.getAlgorithm().equals(KeyAlgorithm.RSA.name())) {
            throw new IllegalArgumentException("The provided key isn't an RSA key!");
        }
        return RSA_HEADER + MIME_ENCODER.encodeToString(publicKey.getEncoded()) + RSA_FOOTER;
    }

    public static PublicKey publicRSAKeyFrom(byte[] data2) {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(data2);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KeyAlgorithm.RSA.name());
            return keyFactory.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum KeyAlgorithm {
        RSA;

    }

    public static enum SignatureAlgorithm {
        SHA256withRSA,
        SHA1withRSA;

    }
}

