/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public record MappedCollection<O, R>(@NotNull Collection<O> original, @NotNull Function<O, R> mapper) implements Collection<R>
{
    public static <O extends AtomicReference<R>, R> MappedCollection<O, R> plainReferences(@NotNull Collection<O> original) {
        return new MappedCollection<AtomicReference, Object>(original, AtomicReference::getPlain);
    }

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        for (O entry2 : this.original) {
            if (!this.mapper.apply(entry2).equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<R> iterator() {
        final Iterator<O> iterator2 = this.original.iterator();
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public R next() {
                return MappedCollection.this.mapper.apply(iterator2.next());
            }
        };
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        throw new UnsupportedOperationException("Unsupported array object");
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
        throw new UnsupportedOperationException("Unsupported array generic");
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c.size() > this.original.size()) {
            return false;
        }
        for (Object entry2 : c) {
            if (this.contains(entry2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(R t2) {
        throw new UnsupportedOperationException("Unmodifiable collection");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Unmodifiable collection");
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends R> c) {
        throw new UnsupportedOperationException("Unmodifiable collection");
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Unmodifiable collection");
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Unmodifiable collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Unmodifiable collection");
    }
}

