/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.binary;

import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.Either;
import net.minestom.server.utils.binary.Readable;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBT;

public class BinaryReader
extends InputStream {
    private final NetworkBuffer buffer;

    public BinaryReader(@NotNull NetworkBuffer buffer) {
        this.buffer = buffer;
    }

    public BinaryReader(@NotNull ByteBuffer buffer) {
        this.buffer = new NetworkBuffer(buffer);
    }

    public BinaryReader(byte[] bytes) {
        this(ByteBuffer.wrap(bytes));
    }

    public int readVarInt() {
        return this.buffer.read(NetworkBuffer.VAR_INT);
    }

    public long readVarLong() {
        return this.buffer.read(NetworkBuffer.VAR_LONG);
    }

    public boolean readBoolean() {
        return this.buffer.read(NetworkBuffer.BOOLEAN);
    }

    public byte readByte() {
        return this.buffer.read(NetworkBuffer.BYTE);
    }

    public short readShort() {
        return this.buffer.read(NetworkBuffer.SHORT);
    }

    public int readUnsignedShort() {
        return this.buffer.read(NetworkBuffer.SHORT) & 0xFFFF;
    }

    public int readInteger() {
        return this.buffer.read(NetworkBuffer.INT);
    }

    public int readInt() {
        return this.buffer.read(NetworkBuffer.INT);
    }

    public long readLong() {
        return this.buffer.read(NetworkBuffer.LONG);
    }

    public float readFloat() {
        return this.buffer.read(NetworkBuffer.FLOAT).floatValue();
    }

    public double readDouble() {
        return this.buffer.read(NetworkBuffer.DOUBLE);
    }

    public String readSizedString(int maxLength) {
        int length = this.readVarInt();
        byte[] bytes = new byte[length];
        try {
            for (int i = 0; i < length; ++i) {
                bytes[i] = this.readByte();
            }
        }
        catch (BufferUnderflowException e) {
            throw new RuntimeException("Could not read " + length + ", " + this.buffer.readableBytes() + " remaining.");
        }
        String str = new String(bytes, StandardCharsets.UTF_8);
        Check.stateCondition(str.length() > maxLength, "String length ({0}) was higher than the max length of {1}", length, maxLength);
        return str;
    }

    public String readSizedString() {
        return this.buffer.read(NetworkBuffer.STRING);
    }

    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.readByte();
        }
        return bytes;
    }

    public byte[] readByteArray() {
        return this.readBytes(this.readVarInt());
    }

    public String[] readSizedStringArray(int maxLength) {
        int size = this.readVarInt();
        String[] strings = new String[size];
        for (int i = 0; i < size; ++i) {
            strings[i] = this.readSizedString(maxLength);
        }
        return strings;
    }

    public String[] readSizedStringArray() {
        return this.readSizedStringArray(Integer.MAX_VALUE);
    }

    public int[] readVarIntArray() {
        int size = this.readVarInt();
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.readVarInt();
        }
        return array;
    }

    public long[] readVarLongArray() {
        int size = this.readVarInt();
        long[] array = new long[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.readVarLong();
        }
        return array;
    }

    public long[] readLongArray() {
        int size = this.readVarInt();
        long[] array = new long[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    public byte[] readRemainingBytes() {
        return this.buffer.read(NetworkBuffer.RAW_BYTES);
    }

    public Point readBlockPosition() {
        return this.buffer.read(NetworkBuffer.BLOCK_POSITION);
    }

    public UUID readUuid() {
        return this.buffer.read(NetworkBuffer.UUID);
    }

    public ItemStack readItemStack() {
        return this.buffer.read(NetworkBuffer.ITEM);
    }

    public Component readComponent(int maxLength) {
        String jsonObject = this.readSizedString(maxLength);
        return GsonComponentSerializer.gson().deserialize(jsonObject);
    }

    public Component readComponent() {
        return this.buffer.read(NetworkBuffer.COMPONENT);
    }

    public <T extends Readable> T read(@NotNull @NotNull Supplier<@NotNull T> supplier) {
        Readable result2 = (Readable)supplier.get();
        result2.read(this);
        return (T)result2;
    }

    @NotNull
    public <T extends Readable> T[] readArray(@NotNull @NotNull Supplier<@NotNull T> supplier) {
        Readable[] result2 = new Readable[this.readVarInt()];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = (Readable)supplier.get();
            result2[i].read(this);
        }
        return result2;
    }

    public <T> List<T> readVarIntList(@NotNull Function<BinaryReader, T> supplier) {
        return this.readList(this.readVarInt(), supplier);
    }

    public <T> List<T> readByteList(@NotNull Function<BinaryReader, T> supplier) {
        return this.readList(this.readByte(), supplier);
    }

    public <L, R> Either<L, R> readEither(Function<BinaryReader, L> leftReader, Function<BinaryReader, R> rightReader) {
        if (this.readBoolean()) {
            return Either.left(leftReader.apply(this));
        }
        return Either.right(rightReader.apply(this));
    }

    private <T> List<T> readList(int length, @NotNull Function<BinaryReader, T> supplier) {
        ArrayList<T> list2 = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            list2.add(supplier.apply(this));
        }
        return list2;
    }

    @Override
    public int read() {
        return this.readByte() & 0xFF;
    }

    @Override
    public int available() {
        return this.buffer.readableBytes();
    }

    public NBT readTag() {
        return this.buffer.read(NetworkBuffer.NBT);
    }

    public byte[] extractBytes(Runnable extractor) {
        int startingPosition = this.buffer.readIndex();
        extractor.run();
        int endingPosition = this.buffer.readIndex();
        byte[] output = new byte[endingPosition - startingPosition];
        this.buffer.copyTo(this.buffer.readIndex(), output, 0, output.length);
        return output;
    }
}

