/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import org.jetbrains.annotations.NotNull;

public class StringUtils {
    public static final String SPACE = " ";
    public static final char SPACE_CHAR = ' ';

    public static int countMatches(@NotNull CharSequence str, char ch) {
        if (str.length() == 0) {
            return 0;
        }
        int count2 = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (ch != str.charAt(i)) continue;
            ++count2;
        }
        return count2;
    }

    public static double jaroWinklerScore(String s1, String s2) {
        if (s1 == null || s2 == null || s1.isEmpty() || s2.isEmpty()) {
            return 0.0;
        }
        if (s1.equals(s2)) {
            return 1.0;
        }
        int prefixMatch = 0;
        int matches = 0;
        int transpositions = 0;
        int maxLength = Math.max(s1.length(), s2.length());
        int maxMatchDistance = Math.max((int)Math.floor((double)maxLength / 2.0) - 1, 0);
        String shorter = s1.length() < s2.length() ? s1 : s2;
        String longer = s1.length() >= s2.length() ? s1 : s2;
        block0: for (int i = 0; i < shorter.length(); ++i) {
            boolean match;
            boolean bl = match = shorter.charAt(i) == longer.charAt(i);
            if (match) {
                if (i < 4) {
                    ++prefixMatch;
                }
                ++matches;
                continue;
            }
            for (int j = Math.max(i - maxMatchDistance, 0); j < Math.min(i + maxMatchDistance, longer.length()); ++j) {
                if (i == j) continue;
                boolean bl2 = match = shorter.charAt(i) == longer.charAt(j);
                if (!match) continue;
                ++transpositions;
                continue block0;
            }
        }
        if (matches == 0) {
            return 0.0;
        }
        transpositions = (int)((double)transpositions / 2.0);
        double score = 0.3334 * ((double)matches / (double)longer.length() + (double)matches / (double)shorter.length() + (double)(matches - transpositions) / (double)matches);
        if (score < 0.7) {
            return score;
        }
        return score + (double)prefixMatch * 0.1 * (1.0 - score);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String unescapeJavaString(String st) {
        StringBuilder sb = new StringBuilder(st.length());
        int i = 0;
        while (true) {
            block18: {
                int ch;
                block16: {
                    char nextChar;
                    block17: {
                        if (i >= st.length()) {
                            return sb.toString();
                        }
                        ch = st.charAt(i);
                        if (ch != 92) break block16;
                        char c = nextChar = i == st.length() - 1 ? (char)'\\' : (char)st.charAt(i + 1);
                        if (nextChar < 48 || nextChar > 55) break block17;
                        String code = "" + nextChar;
                        if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                            code = code + st.charAt(i + 1);
                            if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                                code = code + st.charAt(i + 1);
                                ++i;
                            }
                        }
                        sb.append((char)Integer.parseInt(code, 8));
                        break block18;
                    }
                    switch (nextChar) {
                        case '\\': {
                            ch = 92;
                            break;
                        }
                        case 'b': {
                            ch = 8;
                            break;
                        }
                        case 'f': {
                            ch = 12;
                            break;
                        }
                        case 'n': {
                            ch = 10;
                            break;
                        }
                        case 'r': {
                            ch = 13;
                            break;
                        }
                        case 't': {
                            ch = 9;
                            break;
                        }
                        case '\"': {
                            ch = 34;
                            break;
                        }
                        case '\'': {
                            ch = 39;
                            break;
                        }
                        case 'u': {
                            if (i >= st.length() - 5) {
                                ch = 117;
                                break;
                            }
                            int code = Integer.parseInt("" + st.charAt(i + 2) + st.charAt(i + 3) + st.charAt(i + 4) + st.charAt(i + 5), 16);
                            sb.append(Character.toChars(code));
                            i += 5;
                            break block18;
                        }
                    }
                    ++i;
                }
                sb.append((char)ch);
            }
            ++i;
        }
    }
}

