/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static boolean getBoolean(String name2, boolean defaultValue) {
        boolean result2 = defaultValue;
        try {
            String value = System.getProperty(name2);
            if (value != null) {
                result2 = Boolean.parseBoolean(value);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return result2;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public static String getString(@NotNull String name2, @Nullable String defaultValue) {
        return System.getProperty(name2, defaultValue);
    }
}

